package com.sfa.operation.domain.sales.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * 营销中心-活动计划-零食陈列（计划+执行）
 * @TableName sales_ap_snacks_display
 */
@TableName(value ="sales_ap_snacks_display")
@Data
public class SalesApSnacksDisplay implements Serializable {
    /**
     * 主键ID
     */
    @TableId(type = IdType.AUTO)
    private Long sasdId;
    private Date salesMonth;

    /**
     * 销售大区
     */
    private String regionName;

    /**
     * 销售战区
     */
    private String districtName;

    /**
     * 经销商-省份
     */
    private String dealerProvince;

    /**
     * 经销商-城市
     */
    private String dealerCity;

    /**
     * 经销商-代码
     */
    private String dealerCode;

    /**
     * 经销商名称
     */
    private String dealerName;

    /**
     * 经销商类型
     */
    private String dealerType;

    /**
     * 开户日期
     */
    private Date openingDate;

    /**
     * 闭户日期
     */
    private Date closingDate;

    /**
     * 大区总监
     */
    private String regionManager;

    /**
     * 战区经理
     */
    private String districtManager;

    /**
     * 城市经理
     */
    private String cityManager;

    /**
     * 系统名称
     */
    private String lineName;

    /**
     * 系统类型
     */
    private String lineType;

    /**
     * 渠道大类
     */
    private String channelDl;

    /**
     * 渠道小类
     */
    private String channelXl;

    /**
     * 系统业态
     */
    private String lineLf;

    /**
     * 是否直营
     */
    private String isDirect;

    /**
     * 门店编码
     */
    private String storeCode;

    /**
     * 门店名称
     */
    private String storeName;

    /**
     * 门店计数
     */
    private String storeCount;

    /**
     * 门店地址
     */
    private String storeAddress;

    /**
     * 计划-陈列形式
     */
    private String plannedDisplay;

    /**
     * 实际-陈列形式
     */
    private String actualDisplay;

    /**
     * 计划-端架数量（组）
     */
    private Double plannedEndCapQty;

    /**
     * 实际-端架数量（组）
     */
    private Double actualEndCapQty;

    /**
     * 计划-陈列费用
     */
    private BigDecimal totalCost;

    /**
     * 付费陈列- 是否
     */
    private String paidDisplay;

    /**
     * 当月拜访目标-是否
     */
    private String monthlyVisitTarget;

    /**
     * 实际是否拜访
     */
    private String monthlyVisited;
    private Date createTime;
    private String updateBy;
    private Date updateTime;


    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}