package com.sfa.operation.domain.basedata.dao.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.sfa.common.core.utils.bean.BeanUtils;
import com.sfa.operation.domain.basedata.dao.IBaseProductDao;
import com.sfa.operation.domain.basedata.entity.BaseProduct;
import com.sfa.operation.domain.basedata.mapper.BaseProductMapper;
import com.sfa.operation.pojo.basedata.response.BaseProductDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author : liqiulin
 * @date : 2025-10-30 14
 * @describe :
 */
@DS("bi")
@Service
public class BaseProductDaoImpl implements IBaseProductDao {
    @Autowired
    private BaseProductMapper baseProductMapper;

    @Override
    public BaseProductDto selectOneByProCode(String proCode) {
        LambdaQueryWrapper<BaseProduct> qw = new LambdaQueryWrapper<BaseProduct>().eq(BaseProduct::getPrdCode, proCode);
        BaseProduct baseProduct = baseProductMapper.selectOne(qw);
        return BeanUtils.transitionDto(baseProduct, BaseProductDto.class);
    }
}
