package com.sfa.operation.controller.sales.excel;

import com.sfa.common.core.domain.R;
import com.sfa.operation.pojo.sales.request.ImportApExcelRequest;
import com.sfa.operation.service.sales.export.IImportExcelService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * @Author: DouXinYu
 * @Date: 2025-12-10 15:21
 * @Description: AP导入excel(填报)控制类
 */

@RestController
@RequestMapping("/sales/import")
public class ApImportExcelController {

    @Autowired
    private IImportExcelService importExcelService;

    @PostMapping("/upload")
    public R importApDisplayExcel(@RequestBody ImportApExcelRequest request) {
        return importExcelService.importApExcel(request);
    }

    @PostMapping("/update")
    public R updateApDisplayExcel(@RequestBody ImportApExcelRequest request) {
        return importExcelService.updateApEntity(request);
    }

}
