package com.sfa.operation.domain.zzhao.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 证照中心-质检报告表
 * @TableName zz_product_quality
 */
@TableName(value ="zz_product_quality")
@Data
public class ZzProductQuality implements Serializable {
    /**
     * 表ID
     */
    @TableId(type = IdType.AUTO)
    private Long zpqId;

    /**
     * 料号
     */
    private String prdCode;

    /**
     * 品名
     */
    private String prdName;

    /**
     * 生产批号
     */
    private String manufactureBatchNo;

    /**
     * 质检报告地址
     */
    private String qualityUrl;

    /**
     * 发货日期
     */
    private Date shipDate;

    /**
     * 生产厂家名称
     */
    private String manufacturersName;
    /**
     * 归属部门(工厂)编码
     */
    private Long deptId;
    /**
     * 创建者
     */
    private String createBy;
    private Date createTime;
    private String updateBy;
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}