package com.sfa.operation.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @Author: DouXinYu
 * @Date: 2025-12-11 15:18
 * @Description: OSS配置属性
 */

@Data
@Component
@ConfigurationProperties(prefix = "aliyun")
public class OssConfigProperties{
    /**
     * 访问密钥ID
     */
    private String accessKeyId;
    /**
     * 访问密钥
     */
    private String accessKeySecret;

    /**
     * OSS配置属性
     */
    private Oss oss = new Oss();

    /**
     * OSS其他配置项
     */
    @Data
    public static class Oss{
        /**
         * 地域ID
         */
        private String regionId;
        /**
         * 存储空间名称
         */
        private String bucketName;
        /**
         * 静态网站访问地址
         */
        private String webJsLink;
        /**
         * 角色授权
         */
        private String stsRoleArm;

        private String sessionName;
        /**
         * 静态网站访问地址前缀
         */
        private static final String END_POINT_PREFIX = "https://";

        /**
         * 静态网站访问地址后缀
         */
        private static final String END_POINT_SUFFIX = ".aliyuncs.com";

        /**
         * 获取静态网站访问地址
         * @return 静态网站访问地址
         */
        public String getEndPoint(){
            return END_POINT_PREFIX + this.getRegionId() + END_POINT_SUFFIX;
        }
    }


}
