package com.sfa.operation.service.risk.impl;


import com.sfa.common.core.exception.ServiceException;
import com.sfa.common.core.utils.StringUtils;
import com.sfa.common.core.utils.bean.BeanUtils;
import com.sfa.operation.domain.risk.dao.IRiskStoreTaskDao;
import com.sfa.operation.domain.risk.entity.RiskStoreTask;
import com.sfa.operation.pojo.risk.request.RiskStoreTaskVo;
import com.sfa.operation.pojo.risk.response.RiskInspectStoreDto;
import com.sfa.operation.pojo.risk.response.RiskStoreTaskDto;
import com.sfa.operation.service.risk.IRiskStoreCoreService;
import com.sfa.operation.service.risk.IRiskStoreTaskCoreService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2025-08-28 11
 * @describe :
 */
@Service
public class RiskStoreTaskCoreServiceImpl implements IRiskStoreTaskCoreService {
    @Autowired
    private IRiskStoreTaskDao riskStoreTaskDao;
    @Autowired
    private IRiskStoreCoreService riskStoreCoreService;

    @Override
    public RiskStoreTaskDto.RiskStoreTaskDetailDto saveStoreDetail(RiskStoreTaskVo.TaskDetailVo taskDetail) {
        return riskStoreTaskDao.saveStoreDetail(taskDetail.getRstId(), taskDetail.getDetailName());
    }

    @Override
    public RiskStoreTaskDto.RiskStoreTaskDetailDto updateStoreDetail(RiskStoreTaskDto.RiskStoreTaskDetailDto riskStoreTaskDetailDto) {
        return riskStoreTaskDao.updateStoreDetail(riskStoreTaskDetailDto);
    }

    @Override
    public void deleteStoreDetail(Long rstdId) {
        riskStoreTaskDao.deleteStoreDetail(rstdId);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public RiskStoreTaskDto saveOrUpdateStore(RiskStoreTaskVo riskStoreTaskVo) {
        // 保存来源勤策的门店
        if (Objects.nonNull(riskStoreTaskVo.getStoreCode())) {
            RiskInspectStoreDto storeDto = riskStoreCoreService.saveInspectStore(riskStoreTaskVo);
            riskStoreTaskVo.setStoreName(StringUtils.isNotBlank(storeDto.getRStoreName()) ? storeDto.getRStoreName() : riskStoreTaskVo.getStoreName());
        }

        RiskStoreTaskDto taskDto = null;
        // 是否新建
        if (Objects.isNull(riskStoreTaskVo.getRstId())) {
            RiskStoreTaskDto insertTaskDto = BeanUtils.transitionDto(riskStoreTaskVo, RiskStoreTaskDto.class);
            insertTaskDto.setCreateBy(riskStoreTaskVo.getOperName());
            insertTaskDto.setCreateEmpNo(riskStoreTaskVo.getOperEmpNo());
            taskDto = riskStoreTaskDao.insert(insertTaskDto);
        } else {
            RiskStoreTask riskStoreTask = riskStoreTaskDao.selectById(riskStoreTaskVo.getRstId());
            if (Objects.isNull(riskStoreTask)) {
                throw new ServiceException("售点任务不存在");
            }
            riskStoreTaskVo.setStoreName(StringUtils.isNotBlank(riskStoreTaskVo.getRStoreName()) ? riskStoreTaskVo.getRStoreName() : riskStoreTaskVo.getStoreName());
            RiskStoreTaskDto updateTaskDto = new RiskStoreTaskDto();
            BeanUtils.copyProperties(riskStoreTaskVo, updateTaskDto);
            updateTaskDto.setUpdateBy(riskStoreTaskVo.getOperName());
            updateTaskDto.setLhlds(StringUtils.pArr(riskStoreTaskVo.getLhldArr()));
            updateTaskDto.setCgclRiskR(StringUtils.pArr(riskStoreTaskVo.getCgclRiskRArr()));
            updateTaskDto.setDqclRiskR(StringUtils.pArr(riskStoreTaskVo.getDqclRiskRArr()));
            updateTaskDto.setLongTimePictures(StringUtils.pArr(riskStoreTaskVo.getLongTimePictureArr()));
            taskDto = riskStoreTaskDao.updateInspectStore(updateTaskDto);
        }
        return taskDto;
    }

}
