package com.sfa.operation.domain.sales.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * 营销中心-活动计划-陈列（计划+执行）
 * @TableName sales_ap_display
 */
@TableName(value ="sales_ap_display")
@Data
public class SalesApDisplay implements Serializable {
    /**
     * 主键ID
     */
    @TableId(type = IdType.AUTO)
    private Long sadId;

    /**
     * 陈列所属月份
     */
    private Date salesMonth;

    /**
     * 销售大区
     */
    private String regionName;

    /**
     * 销售战区
     */
    private String districtName;

    /**
     * 经销商-省份
     */
    private String dealerProvince;

    /**
     * 经销商-城市
     */
    private String dealerCity;

    /**
     * 经销商-代码
     */
    private String dealerCode;

    /**
     * 经销商名称
     */
    private String dealerName;

    /**
     * 经销商-类型
     */
    private String dealerType;

    /**
     * 开户日期
     */
    private Date openingDate;

    /**
     * 闭户日期
     */
    private Date closingDate;

    /**
     * 大区总监
     */
    private String regionManager;

    /**
     * 战区经理
     */
    private String districtManager;

    /**
     * 城市经理
     */
    private String cityManager;

    /**
     * 门店编码
     */
    private String storeCode;

    /**
     * 门店名称
     */
    private String storeName;

    /**
     * 门店-省份
     */
    private String storeProvince;

    /**
     * 门店-城市
     */
    private String storeCity;

    /**
     * 系统名称
     */
    private String lineName;

    /**
     * 系统类型
     */
    private String lineType;

    /**
     * 渠道大类
     */
    private String channelDl;

    /**
     * 渠道小类
     */
    private String channelXl;

    /**
     * 门店类型
     */
    private String storeType;

    /**
     * 系统业态
     */
    private String systemFormat;

    /**
     * 门店面积
     */
    private String storeArea;

    /**
     * 门店分级（销量坎级）
     */
    private String storeLevel;

    /**
     * 门店地址
     */
    private String storeAddress;

    /**
     * 品项数
     */
    private Integer productCount;

    /**
     * 大业态测试-动销模型
     */
    private String lfSalesModel;

    /**
     * 大业态测试-月均POS
     */
    private String lfMonthlyPos;

    /**
     * 计划主货架-形式
     */
    private String plannedMainShelfType;

    /**
     * 计划主货架-数量
     */
    private Integer plannedMainShelfQty;

    /**
     * 计划主货架-单个费用
     */
    private BigDecimal plannedMainShelfUnitCost;

    /**
     * 计划主货架-总费用
     */
    private BigDecimal plannedMainShelfTotalCost;

    /**
     * 实际主货架-形式
     */
    private String actualMainShelfType;

    /**
     * 实际主货架-数量
     */
    private Integer actualMainShelfQty;

    /**
     * 实际主货架-是否执行
     * 主货架目标网点数>=1时，为执行/未执行
     */
    private String actualMainShelfExecuted;

    /**
     * 主货架目标网点数
     */
    private Integer mainShelfTypeSn;

    /**
     * 计划端架-数量
     */
    private Double plannedEndCapQty;

    /**
     * 计划端架-总费用
     */
    private BigDecimal plannedEndCapTotalCost;

    /**
     * 计划端架-单个费用
     */
    private BigDecimal plannedEndCapUnitCost;

    /**
     * 实际端架-数量
     */
    private Double actualEndCapQty;

    /**
     * 实际端架-是否执行
     * 端架目标网点数>=1时，为执行/未执行
     */
    private String actualEndCapExecuted;

    /**
     * 端架目标网点数
     */
    private Integer endCapQtySn;

    /**
     * 计划地堆-平米数（㎡）
     */
    private Double plannedFloorStackArea;

    /**
     * 计划地堆-数量
     */
    private Integer plannedFloorStackQty;

    /**
     * 计划主题地堆-是否
     */
    private String plannedThemedFloorStack;

    /**
     * 计划地堆-总费用
     */
    private BigDecimal plannedFloorStackTotalCost;

    /**
     * 计划折算1㎡-单个费用
     */
    private BigDecimal plannedFloorStackUnitCostPerSqm;

    /**
     * 实际地堆-平米数（㎡）
     */
    private Double actualFloorStackArea;

    /**
     * 实际地堆-数量
     */
    private Integer actualFloorStackQty;

    /**
     * 实际主题地堆-是否
     */
    private String actualThemedFloorStack;

    /**
     * 实际地堆是否执行
     * 地堆目标网点数 >=1时，为执行/未执行
     */
    private String actualFloorStackExecuted;

    /**
     * 地堆目标网点数
     */
    private Integer floorStackAreaSn;

    /**
     * 计划多点陈列-数量+形式
     */
    private String plannedMultiDisplay;

    /**
     * 计划多点陈列-总费用
     */
    private BigDecimal plannedMultiDisplayTotalCost;

    /**
     * 实际多点陈列-数量+形式
     */
    private String actualMultiDisplay;

    /**
     * 实际多点陈列-是否执行
     * 多点陈列目标网点数>=1时，为执行/未执行
     */
    private String actualMultiDisplayExecuted;

    /**
     * 多点陈列目标网点数
     */
    private Integer multiPointDisplaySn;

    /**
     * 计划挂条-数量+形式
     */
    private String plannedHangingStripQuantityForm;

    /**
     * 实际挂条-数量+形式
     */
    private String actualHangingStripQuantityForm;

    /**
     * 挂条-是否执行
     * 挂条目标网点数>=1时，为执行/未执行
     */
    private String hangingStripExecuted;

    /**
     * 挂条目标网点数
     */
    private Integer hangingStripSn;

    /**
     * 合计费用-费用
     */
    private BigDecimal totalCost;

    /**
     * 合计费用-费率（%）
     */
    private Double totalCostRate;

    /**
     * 常规陈列是否执行,有计划默认否
     */
    private String regularDisplayExecuted;

    /**
     * 付费陈列- 是否
     */
    private String paidDisplay;

    /**
     * 当月拜访目标
     */
    private String monthlyVisitTarget;

    /**
     * 当月是否拜访
     */
    private String monthlyVisited;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新者
     */
    private String updateBy;

    /**
     * 更新时间
     */
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}