package com.sfa.operation.service.sales.export.impl;

import com.sfa.common.core.domain.R;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.CheckedException;
import com.sfa.operation.factory.ApExportExcelStrategyFactory;
import com.sfa.operation.pojo.sales.request.SalesApRequest;
import com.sfa.operation.service.sales.export.IExportExcelService;
import com.sfa.operation.strategy.IExportApExcelStrategy;
import com.sfa.operation.util.excel.ExcelUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;


/**
 * @Author: DouXinYu
 * @Date: 2025-12-09 14:20
 * @Description: 导出excel服务实现类
 */
@Slf4j
@Service
public class ExportExcelServiceImpl implements IExportExcelService {
    @Autowired
    private ApExportExcelStrategyFactory exportApExcelStrategyFactory;


    @Override
    public R exportApDisplayExcel(SalesApRequest salesApRequest, HttpServletResponse response) {
        if (salesApRequest.getSalesMonth() == null || salesApRequest.getSalesMonth().trim().isEmpty()){
            throw new CheckedException(ECode.SALES_AP_EXPORT_ERROR);
        }
        try {
            IExportApExcelStrategy strategy = exportApExcelStrategyFactory.getStrategy(salesApRequest.getPageType());
            String fileNamePrefix = strategy.getExportFileNamePrefix();
            log.info("导出前缀为：{}的excel", fileNamePrefix);
            byte[] excelBytesArray = strategy.generateExcel(salesApRequest);
            ExcelUtils.exportExcelBytesToResponse(excelBytesArray, response, fileNamePrefix);
            log.info("数据导出成功！");
            return R.ok(R.SUCCESS, "数据导出成功") ;
        } catch (Exception e) {
            log.error("数据导出异常！具体错误原因:", e);
            return R.fail(910,e.getMessage());
        }

    }
}
