package com.sfa.operation.enums;
import lombok.Getter;

/**
 * @Author: DouXinYu
 * @Date: 2025-12-05 18:31
 * @Description: ap导出页面类型枚举类(与策略对应)
 */

@Getter
public enum ExportAPType {
    /**
     *  常规陈列策略
     */
    NORMAL_DISPLAY_EXPORT("normalDisplayExportStrategy"),
    /**
     * 档期计划策略
     */
    PROMOTION_PLAN_EXPORT("promotionPlanExportStrategy"),
    /**
     * 零食陈列策略
     */
    SNACK_DISPLAY_EXPORT("snackDisplayExportStrategy"),
    /**
     * 三米两秒策略
     */
    THREE_METER_TWO_SECONDS_EXPORT("threeMeterTwoSecondsExportStrategy"),
    /**
     * 六小金刚策略
     */
    SIX_KINGkONG_EXPORT("sixKingKongExportStrategy"),
    /**
     * 档期陈列策略
     */
    PROMOTION_DISPLAY_EXPORT("promotionDisplayExportStrategy");

    private final String strategy;
    ExportAPType(String strategy) {
        this.strategy = strategy;
    }
}
