package com.sfa.operation.controller.sales.core;

import com.sfa.common.core.constant.RoleConstants;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.CheckedException;
import com.sfa.common.security.annotation.Logical;
import com.sfa.common.security.annotation.RequiresRoles;
import com.sfa.common.security.utils.SecurityUtils;
import com.sfa.operation.pojo.sales.request.SalesApRequest;
import com.sfa.operation.service.qc.IQinceMarketEmployeeService;
import com.sfa.operation.service.sales.IApDisplayCoreService;
import com.sfa.system.api.domain.SysRole;
import com.sfa.system.api.model.LoginUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Optional;

/**
 * @author : liqiulin
 * @date : 2025-09-16 15
 * @describe : 常规陈列、档期陈列、零食陈列
 */
@RestController
public class ApDisplayCoreController {
    @Autowired
    private IApDisplayCoreService apDisplayCoreService;

    /**
     * 常规陈列 根据id更新
     */
    @PutMapping("/sales/ap_display/core/{id}")
    @RequiresRoles(value = {RoleConstants.OPERATION_AP_MANAGER, RoleConstants.OPERATIONZQ_AP_MANAGER, RoleConstants.OPERATIONDQ_AP_MANAGER, RoleConstants.DISTRICT_AP_MANAGER}, logical = Logical.OR)
    public void putDetail(@PathVariable("id") Long sadId, @RequestBody SalesApRequest request){
        request.setSadId(sadId);
        apDisplayCoreService.updateDetail(request);
    }

    /**
     * 档期陈列 根据id更新
     */
    @PutMapping("/sales/ap_display/core_pro/{id}")
    @RequiresRoles(value = {RoleConstants.OPERATION_AP_MANAGER, RoleConstants.OPERATIONZQ_AP_MANAGER, RoleConstants.OPERATIONDQ_AP_MANAGER, RoleConstants.DISTRICT_AP_MANAGER}, logical = Logical.OR)
    public void putProDisplayDetail(@PathVariable("id") Long sapdId, @RequestBody SalesApRequest request){
        request.setSapdId(sapdId);
        apDisplayCoreService.putProDisplayDetail(request);
    }

    /**
     * 零食陈列 根据id更新
     */
    @PutMapping("/sales/ap_display/core_snack/{id}")
    @RequiresRoles(value = {RoleConstants.OPERATION_AP_MANAGER, RoleConstants.OPERATIONZQ_AP_MANAGER, RoleConstants.OPERATIONDQ_AP_MANAGER, RoleConstants.DISTRICT_AP_MANAGER}, logical = Logical.OR)
    public void putSnackDisplayDetail(@PathVariable("id") Long sasdId, @RequestBody SalesApRequest request){
        request.setSasdId(sasdId);
        apDisplayCoreService.putSnackDisplayDetail(request);
    }

    /**
     * 三米两秒
     */
    @PutMapping("/sales/ap_display/core_s/{id}")
    @RequiresRoles(value = {RoleConstants.OPERATION_AP_MANAGER, RoleConstants.OPERATIONZQ_AP_MANAGER, RoleConstants.OPERATIONDQ_AP_MANAGER, RoleConstants.DISTRICT_AP_MANAGER}, logical = Logical.OR)
    public void putDisplaySDetail(@PathVariable("id") Long sadsId, @RequestBody SalesApRequest request){
        request.setSadsId(sadsId);
        apDisplayCoreService.putDisplaySDetail(request);
    }

    /**
     * 六小金刚
     */
    @PutMapping("/sales/ap_display/core_j/{id}")
    @RequiresRoles(value = {RoleConstants.OPERATION_AP_MANAGER, RoleConstants.OPERATIONZQ_AP_MANAGER, RoleConstants.OPERATIONDQ_AP_MANAGER, RoleConstants.DISTRICT_AP_MANAGER}, logical = Logical.OR)
    public void putDisplayJDetail(@PathVariable("id") Long sadjId, @RequestBody SalesApRequest request){
        request.setSadjId(sadjId);
        apDisplayCoreService.putDisplayJDetail(request);
    }

    /**
     * 更新AP促销计划详情
     * 大区总、战区经理、城市经理、TM，可以更新
     */
    @PutMapping("/sales/ap_promotion/core/{id}")
    @RequiresRoles(value = {RoleConstants.OPERATION_AP_MANAGER, RoleConstants.OPERATIONZQ_AP_MANAGER, RoleConstants.OPERATIONDQ_AP_MANAGER, RoleConstants.DISTRICT_AP_MANAGER}, logical = Logical.OR)
    public void putPromotionDetail(@PathVariable("id") Long sapId, @RequestBody SalesApRequest request) {
        request.setSapId(sapId);
        apDisplayCoreService.putPromotionDetail(request);
    }

}
