package com.sfa.operation.controller.risk.core;

import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.CheckedException;
import com.sfa.common.core.utils.StringUtils;
import com.sfa.common.security.utils.SecurityUtils;
import com.sfa.operation.pojo.risk.request.RiskStoreTaskVo;
import com.sfa.operation.pojo.risk.response.RiskStoreTaskDto;
import com.sfa.operation.service.risk.IRiskStoreTaskCoreService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Objects;

import static com.sfa.common.core.utils.StringUtils.mArr;
import static com.sfa.common.core.utils.StringUtils.pArr;

/**
 * @author : liqiulin
 * @date : 2025-08-27 20
 * @describe : 风控中心-售点稽查
 */
@RestController
@RequestMapping("/risk/core")
public class RiskStoreTaskCoreController {
    @Autowired
    private IRiskStoreTaskCoreService riskstoreTaskCoreService;
   @PostMapping("/i_store")
    public RiskStoreTaskDto inspectStore(@RequestBody RiskStoreTaskVo riskStoreTaskVo) {
        if (riskStoreTaskVo.getRstId() == null &&StringUtils.isBlank(riskStoreTaskVo.getStoreName())){
            throw new CheckedException(ECode.RISK_STORE_TASK_CREATE_ERROR);
        }
        riskStoreTaskVo.setOperName(SecurityUtils.getNickName());
        riskStoreTaskVo.setOperEmpNo(SecurityUtils.getUsername());
        RiskStoreTaskDto dto = riskstoreTaskCoreService.saveOrUpdateStore(riskStoreTaskVo);
        return dto;
    }



    @PostMapping("/i_store_detail")
    public RiskStoreTaskDto.RiskStoreTaskDetailDto inspectStoreDetail(@RequestBody RiskStoreTaskVo riskStoreTaskVo) {
        RiskStoreTaskVo.TaskDetailVo taskDetailVo = riskStoreTaskVo.getTaskDetail();
        if (Objects.isNull(taskDetailVo.getRstdId())){
            return riskstoreTaskCoreService.saveStoreDetail(taskDetailVo);
        }
        // 更新稽核详情
        RiskStoreTaskDto.RiskStoreTaskDetailDto riskStoreTaskDetailDto = new RiskStoreTaskDto.RiskStoreTaskDetailDto();
        BeanUtils.copyProperties(taskDetailVo,riskStoreTaskDetailDto);
        riskStoreTaskDetailDto.setPhotos(pArr(taskDetailVo.getPhotoArr()));
        riskStoreTaskDetailDto.setRiskR(pArr(taskDetailVo.getRiskRArr()));
        riskStoreTaskDetailDto.setKwYmHp210(mArr(taskDetailVo.getKwYmHp210Map()));
        riskStoreTaskDetailDto.setKwYmHp105(mArr(taskDetailVo.getKwYmHp105Map()));
        riskStoreTaskDetailDto.setKwYmHp68(mArr(taskDetailVo.getKwYmHp68Map()));
        riskStoreTaskDetailDto.setKwYmJrdb120(mArr(taskDetailVo.getKwYmJrdb120Map()));
        riskStoreTaskDetailDto.setKwYmNrdb120(mArr(taskDetailVo.getKwYmNrdb120Map()));
        riskStoreTaskDetailDto.setKwYmQg72(mArr(taskDetailVo.getKwYmQg72Map()));
        riskStoreTaskDetailDto.setKwYmQg138(mArr(taskDetailVo.getKwYmQg138Map()));
        riskStoreTaskDetailDto.setKwYmHpjt80(mArr(taskDetailVo.getKwYmHpjt80Map()));
        riskStoreTaskDetailDto.setKwYmLl(mArr(taskDetailVo.getKwYmLlMap()));
        riskStoreTaskDetailDto.setKwYmHpDz(mArr(taskDetailVo.getKwYmHpDzMap()));
        riskStoreTaskDetailDto.setKwYmHpSc(mArr(taskDetailVo.getKwYmHpScMap()));
        return riskstoreTaskCoreService.updateStoreDetail(riskStoreTaskDetailDto);
    }

    @DeleteMapping("/d_store_detail")
    public void deleteStoreDetail(Long rstdId) {
        riskstoreTaskCoreService.deleteStoreDetail(rstdId);
    }




}
