package com.sfa.operation.pojo.risk.response;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author : liqiulin
 * @date : 2025-08-28 14
 * @describe :
 */
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@Data
public class RiskStoreTaskDto {
    /**
     * 主键ID
     */
    private Long rstId;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 门店编码
     */
    private String storeCode;

    /**
     * 门店名称
     */
    private String storeName;

    /**
     * 门店类型
     */
    private String storeType;

    /**
     * 门头照图片
     */
    private String storePicture;

    /**
     * 经销商名称
     */
    private String dealerName;

    /**
     * 经销商编码
     */
    private String dealerCode;

    /**
     * 省份
     */
    private String province;

    /**
     * 城市
     */
    private String city;

    /**
     * 详细地址
     */
    private String address;

    /**
     * 坐标
     */
    private String coordinates;

    /**
     * 礼盒/礼袋是否在售(逗号分隔)
     */
    private String lhlds;
    private String[] lhldArr;

    /**
     * SKU数量
     */
    private Integer skuNum;

    /**
     * 长效图片(逗号分隔)
     */
    private String longTimePictures;
    private String[] longTimePictureArr;

    /**
     * 备注
     */
    private String remark;

    /**
     * 常规陈列判定结果
     */
    private String[] cgclRiskRArr;
    private String cgclRiskR;
    /**
     * 档期陈列判定结果
     */
    private String[] dqclRiskRArr;
    private String dqclRiskR;
    /**
     * 创建人
     */
    private String createBy;

    /**
     * 创建人工号
     */
    private String createEmpNo;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新者
     */
    private String updateBy;

    /**
     * 更新时间
     */
    private Date updateTime;

    private Map<String, List<RiskStoreTaskDetailDto>> detailMap;

    public void tranArr() {
        if (StringUtils.isNotBlank(this.lhlds)){
            this.lhldArr = this.lhlds.split(",");
        }
        if (StringUtils.isNotBlank(this.longTimePictures)){
            this.longTimePictureArr = this.longTimePictures.split(",");
        }
        if (StringUtils.isNotBlank(this.cgclRiskR)){
            this.cgclRiskRArr = this.cgclRiskR.split(",");
        }
        if (StringUtils.isNotBlank(this.dqclRiskR)){
            this.dqclRiskRArr = this.dqclRiskR.split(",");
        }
    }

    @AllArgsConstructor
    @NoArgsConstructor
    @Data
    public static class RiskStoreTaskDetailDto {
        private Long rstdId;
        private Long rstId;
        private String detailName;
        /**
         * 陈列形式
         */
        private String modal;

        /**
         * 陈列费用
         */
        private BigDecimal cost;

        /**
         * 陈列/补差照片
         */
        private String photos;
        /**
         * 检核结果
         */
        private String riskR;

        /**
         * 补差内容
         */
        private String bcNr;

        /**
         * 补差情况
         */
        private String bcQk;

        /**
         * 虎皮210g价格
         */
        private String priceHp210;

        /**
         * 虎皮210g口味铺市月份
         */
        private String kwYmHp210;

        /**
         * 虎皮105g价格
         */
        private String priceHp105;

        /**
         * 虎皮105g口味铺市月份
         */
        private String kwYmHp105;

        /**
         * 虎皮68g价格
         */
        private String priceHp68;

        /**
         * 虎皮68g口味铺市月份
         */
        private String kwYmHp68;

        /**
         * 鸡肉豆堡120g价格
         */
        private String priceJrdb120;

        /**
         * 鸡肉豆堡120g口味铺市月份
         */
        private String kwYmJrdb120;

        /**
         * 牛肉豆堡120g价格
         */
        private String priceNrdb120;

        /**
         * 牛肉豆堡120g口味铺市月份
         */
        private String kwYmNrdb120;

        /**
         * 去骨凤爪72g价格
         */
        private String priceQg72;

        /**
         * 去骨凤爪72g口味铺市月份
         */
        private String kwYmQg72;

        /**
         * 去骨凤爪138g价格
         */
        private String priceQg138;

        /**
         * 去骨凤爪138g口味铺市月份
         */
        private String kwYmQg138;

        /**
         * 虎皮小鸡腿80g价格
         */
        private String priceHpjt80;

        /**
         * 虎皮小鸡腿80g口味铺市月份
         */
        private String kwYmHpjt80;

        /**
         * 老卤价格
         */
        private String priceLl;

        /**
         * 老卤口味铺市月份
         */
        private String kwYmLl;

        /**
         * 虎皮单支价格
         */
        private String priceHpDz;

        /**
         * 虎皮单支口味铺市月份
         */
        private String kwYmHpDz;

        /**
         * 虎皮散称价格
         */
        private String priceHpSc;

        /**
         * 虎皮散称口味铺市月份
         */
        private String kwYmHpSc;

        /**
         * 陈列/补差照片
         */
        private String[] photoArr;
        /**
         * 检核结果
         */
        private String[] riskRArr;

        /**
         * 虎皮210g口味铺市月份
         */
        private Map<String,String> kwYmHp210Map;

        /**
         * 虎皮105g口味铺市月份
         */
        private Map<String,String> kwYmHp105Map;

        /**
         * 虎皮68g口味铺市月份
         */
        private Map<String,String> kwYmHp68Map;

        /**
         * 鸡肉豆堡120g口味铺市月份
         */
        private Map<String,String> kwYmJrdb120Map;

        /**
         * 牛肉豆堡120g口味铺市月份
         */
        private Map<String,String> kwYmNrdb120Map;

        /**
         * 去骨凤爪72g口味铺市月份
         */
        private Map<String,String> kwYmQg72Map;

        /**
         * 去骨凤爪138g口味铺市月份
         */
        private Map<String,String> kwYmQg138Map;

        /**
         * 虎皮小鸡腿80g口味铺市月份
         */
        private Map<String,String> kwYmHpjt80Map;

        /**
         * 老卤口味铺市月份
         */
        private Map<String,String> kwYmLlMap;

        /**
         * 虎皮单支口味铺市月份
         */
        private Map<String,String> kwYmHpDzMap;

        /**
         * 虎皮散称口味铺市月份
         */
        private Map<String,String> kwYmHpScMap;
    }
}
