package com.sfa.operation.controller.zzhao.core;

import com.sfa.common.security.utils.SecurityUtils;
import com.sfa.operation.pojo.zzhao.request.ZzProductQualityVo;
import com.sfa.operation.service.zzhao.IZzProQualityCoreService;
import com.sfa.system.api.model.LoginUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author : liqiulin
 * @date : 2025-10-30 15
 * @describe :
 */
@RestController
@RequestMapping("/zzhao/core/proQuality")
public class ZzProQualityCoreController {
    @Autowired
    private IZzProQualityCoreService zzProQualityCoreService;

    /**
     * 录入质检报告
     */
    @PostMapping("/add")
    public void add(@RequestBody ZzProductQualityVo vo) {
        LoginUser loginUser = SecurityUtils.getLoginUser();
        String deptName = loginUser.getSysUser().getDept().getDeptName();

        vo.setManufacturersName(deptName);
        vo.setCreateBy(loginUser.getNickName());
        zzProQualityCoreService.add(vo);
    }
}
