package com.sfa.operation.factory;

import com.sfa.operation.enums.ExportAPType;
import com.sfa.operation.strategy.IExportApExcelStrategy;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author: DouXinYu
 * @Date: 2025-12-08 16:49
 * @Description: AP导出excel策略工厂类
 */
@Slf4j
@Component
public class ApExportExcelStrategyFactory {
    private final Map<String, IExportApExcelStrategy> exportApExcelStrategyMap;
    //构造器注入
    @Autowired
    public ApExportExcelStrategyFactory(Map<String, IExportApExcelStrategy> exportApExcelStrategyMap) {
        this.exportApExcelStrategyMap = exportApExcelStrategyMap;
    }


    public IExportApExcelStrategy getStrategy(String exportApType) {
        if (exportApType == null || exportApType.trim().isEmpty()) {
            log.error("AP导出Excel策略工厂：传入的导出类型为空!");
            throw new IllegalArgumentException("传入的导出类型为空!");
        }
        ExportAPType typeEnum;
        try {
            typeEnum = ExportAPType.valueOf(exportApType.toUpperCase());
        } catch (IllegalArgumentException e) {
            log.error("AP导出Excel策略工厂：传入的导出类型不存在!目标类型为：{}", exportApType);
            throw new IllegalArgumentException("传入的导出类型不存在!");
        }

        // 从枚举中获取策略Bean名称，再从Map中查找策略
        String strategyBeanName = typeEnum.getStrategy();
        IExportApExcelStrategy strategy = exportApExcelStrategyMap.get(strategyBeanName);
        if (strategy == null) {
            log.error("AP导出Excel策略工厂：未找到对应的导出策略!目标策略Bean名称为：{}", strategyBeanName);
            throw new IllegalArgumentException("未找到对应的导出策略!");
        }

        log.info("AP导出Excel策略工厂：找到对应的导出策略!目标策略Bean名称为：{}", strategyBeanName);
        return strategy;
    }

}
