package com.sfa.operation.domain.zzhao.dao.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.WXLSQLException;
import com.sfa.operation.domain.zzhao.dao.IZzProductQualityDao;
import com.sfa.operation.domain.zzhao.entity.ZzProductQuality;
import com.sfa.operation.domain.zzhao.mapper.ZzProductQualityMapper;
import com.sfa.operation.pojo.zzhao.response.ZzProductQualityDto;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author : liqiulin
 * @date : 2025-10-30 15
 * @describe :
 */
@Service
@DS("bi")
public class ZzProductQualityDaoImpl implements IZzProductQualityDao {
    @Autowired
    private ZzProductQualityMapper zzProductQualityMapper;

    @Override
    public void insert(ZzProductQualityDto dto) {
        try {
            ZzProductQuality entity = new ZzProductQuality();
            BeanUtils.copyProperties(dto, entity);
            zzProductQualityMapper.insert(entity);
        }catch (Exception e){
            String eMsg = e.getCause().getMessage();
            if (eMsg.contains("for key 'psm_unique'")) {
                throw new WXLSQLException(ECode.ZZ_PRODUCT_QUALITY_EXIST_ERROR);
            }
            throw new WXLSQLException(ECode.DB_TABLE_UPDATE_ERROR);
        }
    }
}
