package com.sfa.operation.service.sales.impl;

import cn.hutool.core.date.DatePattern;
import com.sfa.common.security.utils.SecurityUtils;
import com.sfa.operation.domain.sales.dao.*;
import com.sfa.operation.domain.sales.entity.SalesApDisplay;
import com.sfa.operation.pojo.sales.request.SalesApRequest;
import com.sfa.operation.pojo.sales.response.*;
import com.sfa.operation.service.sales.IApDisplayCoreService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2025-09-16 16
 * @describe :
 */
@Service
public class ApDisplayCoreServiceImpl implements IApDisplayCoreService {
    @Autowired
    private ISalesApDisplayDao salesApDisplayDao;
    @Autowired
    private ISalesApSnacksDisplayDao salesApSnacksDisplayDao;
    @Autowired
    private ISalesApPromotionDisplayDao salesApPromotionDisplayDao;
    @Autowired
    private ISalesApDisplaySDao salesApDisplaySDao;
    @Autowired
    private ISalesApDisplayJDao salesApDisplayJDao;
    @Autowired
    private ISalesApPromotionDao salesApPromotionDao;
    @Override
    public void updateDetail(SalesApRequest request) {
        SalesApDisplayDto salesApDisplayDto = new SalesApDisplayDto();
        BeanUtils.copyProperties(request.getDisplay(), salesApDisplayDto);
        salesApDisplayDto.setSadId(request.getSadId());
        salesApDisplayDto.setUpdateBy(SecurityUtils.getNickName());
        salesApDisplayDao.updateDetail(salesApDisplayDto);
    }

    @Override
    public void putSnackDisplayDetail(SalesApRequest request) {
        SalesApSnacksDisplayDto sdDto = new SalesApSnacksDisplayDto();
        BeanUtils.copyProperties(request.getSnackDisplay(), sdDto);
        sdDto.setSasdId(request.getSasdId());
        sdDto.setUpdateBy(SecurityUtils.getNickName());
        salesApSnacksDisplayDao.updateDetail(sdDto);
    }

    @Override
    public void putProDisplayDetail(SalesApRequest request) {
        SalesApPromotionDisplayDto pdDto = new SalesApPromotionDisplayDto();
        BeanUtils.copyProperties(request.getPromotionDisplay(), pdDto);
        pdDto.setSapdId(request.getSapdId());
        pdDto.setUpdateBy(SecurityUtils.getNickName());
        salesApPromotionDisplayDao.updateDetail(pdDto);
    }

    @Override
    public void putDisplaySDetail(SalesApRequest request) {
        SalesApDisplaySDto dsDto = new SalesApDisplaySDto();
        BeanUtils.copyProperties(request.getDisplayS(), dsDto);
        dsDto.setSadsId(request.getSadsId());
        dsDto.setUpdateBy(SecurityUtils.getNickName());
        salesApDisplaySDao.updateDetail(dsDto);
    }

    @Override
    public void putDisplayJDetail(SalesApRequest request) {
        SalesApDisplayJDto djDto = new SalesApDisplayJDto();
        BeanUtils.copyProperties(request.getDisplayJ(), djDto);
        djDto.setSadjId(request.getSadjId());
        djDto.setUpdateBy(SecurityUtils.getNickName());
        salesApDisplayJDao.updateDetail(djDto);
    }

    /**
     *
     * @param updateEntityList
     * @return
     */
    @Override
    public boolean batchUpdate(List<SalesApDisplay> updateEntityList) {
        return salesApDisplayDao.batchUpdate(updateEntityList);
    }

    @Override
    public void putPromotionDetail(SalesApRequest request) {
        // 修改DB 日期值为null
        try {
            SalesApPromotionDto dto = new SalesApPromotionDto();
            SalesApRequest.Promotion promotion = request.getPromotion();
            BeanUtils.copyProperties(promotion, dto);
            dto.setSapId(request.getSapId());
            Date parse = DatePattern.NORM_DATE_FORMAT.parse("2000-01-01");

            if (Objects.isNull(promotion.getActualPromotionStartDate())) {
                dto.setIsActualPromotionStartDate(true);
            } else if (promotion.getActualPromotionStartDate().compareTo(parse) == 0) {
                dto.setIsActualPromotionStartDate(false);
            }else {
                dto.setIsActualPromotionStartDate(true);
            }
            if (Objects.isNull(promotion.getActualPromotionEndDate())) {
                // DB 日期值无需修改
                dto.setIsActualPromotionEndDate(true);
            } else if (promotion.getActualPromotionEndDate().compareTo(parse) == 0) {
                // DB 日期值无需修改
                dto.setIsActualPromotionEndDate(false);
            }else {
                dto.setIsActualPromotionEndDate(true);
            }
            dto.setUpdateBy(SecurityUtils.getNickName());
            salesApPromotionDao.updateById(dto);
        } catch (ParseException e) {
            e.printStackTrace();
        }
    }


}
