package com.sfa.operation.advice;


import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sfa.common.core.domain.R;
import com.sfa.common.core.web.domain.AjaxResult;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

/**
 * @author : liqiulin
 * @date : 2024-10-28 17
 * @describe :自动封装
 */
@RestControllerAdvice
public class ControllerResponseAdvice implements ResponseBodyAdvice<Object>{

    /**
     * response是R类型或者注释了NotControllerResponseAdvice都不进行包装
     */
    @Override
    public boolean supports(MethodParameter methodParameter, Class converterType) {
        if (methodParameter.getParameterType().isAssignableFrom(AjaxResult.class)) {
            return false;
        }
        return !methodParameter.getParameterType().isAssignableFrom(R.class);
    }

    @Override
    public Object beforeBodyWrite(Object body, MethodParameter methodParameter, MediaType selectedContentType, Class selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        // String类型不能直接包装
        if (methodParameter.getGenericParameterType().equals(String.class)) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                // 将数据包装在ResultVo里后转换为json串进行返回
                return objectMapper.writeValueAsString(R.ok(body));
            } catch (JsonProcessingException e) {
                throw new RuntimeException();
            }
        }
        // 包装成R返回
        return R.ok(body);
    }
}
