package com.sfa.operation.pojo.sales.excel;

import lombok.Data;

/**
 * @Author: DouXinYu
 * @Date: 2025-12-10 16:05
 * @Description: 店内执行上报 - 填报 - 常规陈列 导入excel数据传输对象
 */

@Data
public class SalesApDisplayImportExcelDto {

    /**
     * 主键ID
     * 类型：Long
     */
    private Long sadId;

    /**
     * 计划月份
     * 注意：Excel中是"YYYY-MM"字符串，导入时需转换为Date类型
     */
    private String salesMonth;

    /**
     * 销售大区
     * 类型：String
     */
    private String regionName;

    /**
     * 销售战区
     * 类型：String
     */
    private String districtName;

    /**
     * 经销商代码
     * 类型：String
     */
    private String dealerCode;

    /**
     * 经销商名称
     * 类型：String
     */
    private String dealerName;

    /**
     * 门店编码
     * 类型：String
     */
    private String storeCode;

    /**
     * 门店名称
     * 类型：String
     */
    private String storeName;

    /**
     * 系统名称
     * 类型：String
     */
    private String lineName;

    /**
     * 计划主货架-形式
     * 类型：String
     */
    private String plannedMainShelfType;

    /**
     * 实际主货架-形式
     * 类型：String
     */
    private String actualMainShelfType;

    /**
     * 计划主货架-数量
     * 类型：Integer
     */
    private Integer plannedMainShelfQty;

    /**
     * 实际主货架-数量
     * 类型：Integer
     */
    private Integer actualMainShelfQty;

    /**
     * 计划端架-数量
     * 类型：Double
     */
    private Double plannedEndCapQty;

    /**
     * 实际端架-数量
     * 类型：Double
     */
    private Double actualEndCapQty;

    /**
     * 计划地堆-平米数（㎡）
     * 类型：Double
     */
    private Double plannedFloorStackArea;

    /**
     * 实际地堆-平米数（㎡）
     * 类型：Double
     */
    private Double actualFloorStackArea;

    /**
     * 计划地堆-数量
     * 类型：Integer
     */
    private Integer plannedFloorStackQty;

    /**
     * 实际地堆-数量
     * 类型：Integer
     */
    private Integer actualFloorStackQty;

    /**
     * 计划多点陈列-数量+形式
     * 类型：String
     */
    private String plannedMultiDisplay;

    /**
     * 实际多点陈列-数量+形式
     * 类型：String
     */
    private String actualMultiDisplay;

    /**
     * 计划挂条-数量+形式
     * 类型：String
     */
    private String plannedHangingStripQuantityForm;

    /**
     * 实际挂条-数量+形式
     * 类型：String
     */
    private String actualHangingStripQuantityForm;

    /**
     * 错误信息
     * 类型：String
     */
    private String errorMsg;

    /**
     * 行号
     * 类型：Integer
     */
    private Integer rowNum;
}
