package com.sfa.operation.domain.sales.dao.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.sfa.common.core.utils.StringUtils;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.core.web.page.TableSupport;
import com.sfa.operation.domain.sales.dao.ISalesApDisplayDao;
import com.sfa.operation.domain.sales.entity.SalesApDisplay;
import com.sfa.operation.domain.sales.entity.SalesApPromotion;
import com.sfa.operation.domain.sales.mapper.SalesApDisplayMapper;
import com.sfa.operation.domain.sales.wq.SalesApWq;
import com.sfa.operation.pojo.sales.response.SalesApDisplayDto;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2025-09-08 14
 * @describe :
 */
@DS("bi")
@Service
public class SalesApDisplayDaoImpl implements ISalesApDisplayDao {

    @Autowired
    private SalesApDisplayMapper salesapdisMapper;
    @Override
    public PageInfo page(SalesApWq salesApWq) {
        LambdaQueryWrapper<SalesApDisplay> qw = buildWq(salesApWq);
        Page<SalesApDisplay> salesApDisplayPage = salesapdisMapper.selectPage(TableSupport.pageI(), qw);
        PageInfo pageInfo = new PageInfo(salesApDisplayPage);
        return pageInfo;
    }

    @Override
    public void updateDetail(SalesApDisplayDto salesApDisplayDto) {
        SalesApDisplay updateDo = new SalesApDisplay();
        BeanUtils.copyProperties(salesApDisplayDto,updateDo);
        salesapdisMapper.updateById(updateDo);
    }

    @Override
    public Object queryStoreAPReport(SalesApWq build) {
        return salesapdisMapper.queryStoreAPReport(build);
    }

    private LambdaQueryWrapper<SalesApDisplay> buildWq(SalesApWq salesApWq) {
        LambdaQueryWrapper<SalesApDisplay> qw = new LambdaQueryWrapper<>();
        if (StringUtils.isNotBlank(salesApWq.getDealerCode())) {
            qw.eq(SalesApDisplay::getDealerCode, salesApWq.getDealerCode());
        }
        if (!CollectionUtils.isEmpty(salesApWq.getDealerCodes())) {
            qw.in(SalesApDisplay::getDealerCode, salesApWq.getDealerCodes());
        }
        if (StringUtils.isNotBlank(salesApWq.getCityManager())) {
            qw.eq(SalesApDisplay::getCityManager, salesApWq.getCityManager());
        }
        if (Objects.nonNull(salesApWq.getSalesMonth())){
            qw.eq(SalesApDisplay::getSalesMonth, salesApWq.getSalesMonth());
        }
        if (StringUtils.isNotBlank(salesApWq.getDeptName())){
            qw.and(
                    wrapper -> wrapper.like(SalesApDisplay::getRegionName, salesApWq.getDeptName())
                            .or()
                            .like(SalesApDisplay::getDistrictName, salesApWq.getDeptName())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getNickName())){
            qw.and(
                    wrapper -> wrapper.eq(SalesApDisplay::getRegionManager, salesApWq.getNickName())
                            .or()
                            .eq(SalesApDisplay::getDistrictManager, salesApWq.getNickName())
                            .or()
                            .eq(SalesApDisplay::getCityManager, salesApWq.getNickName())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getDealerCN())){
            qw.and(
                    wrapper -> wrapper.like(SalesApDisplay::getDealerName, salesApWq.getDealerCN())
                            .or()
                            .like(SalesApDisplay::getDealerCode, salesApWq.getDealerCN())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getStoreCN())){
            qw.and(
                    wrapper -> wrapper.like(SalesApDisplay::getStoreName, salesApWq.getStoreCN())
                            .or()
                            .like(SalesApDisplay::getStoreCode, salesApWq.getStoreCN())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getLineNameLike())){
            qw.like(SalesApDisplay::getLineName, salesApWq.getLineNameLike());
        }
        return qw;
    }
}
