package com.sfa.operation.pojo.risk.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;

/**
 * @author : liqiulin
 * @date : 2025-08-27 20
 * @describe :
 */
@Data
public class RiskStoreTaskVo {
    private Long rstId;
    /** --------    门店信息    -------- */
    private String storeCode;
    private String storeName;
    /**
     * 重命名店名
     */
    @JsonProperty("rStoreName")
    private String rStoreName;
    private String storeType;
    private String storePicture;
    private String dealerName;
    private String dealerCode;

    /** --------    任务信息 - 总结性    --------*/
    private String province;
    private String city;
    private String address;
    private String coordinates;

    /** --------    其他-开始   --------*/
    /** 礼盒/礼袋是否在售 */
    private String[] lhldArr;
    private Integer skuNum;
    private String remark;
    private String[] longTimePictureArr;

    /**      其他-结束       **/

    /**      竞品 6个字段2025-11-06 19:08:00-开始       **/

    /**
     * 竞品 - 旺家福 SKU 总数
     */
    private  Integer competitorWangjiafuSkuTotal;
    /**
     * 竞品 - 旺家福排面总数
     */
    private  Integer competitorWangjiafuFacingTotal;
    /**
     * 竞品 - 钱家香 SKU 总数
     */
    private  Integer competitorQianjiaxiangSkuTotal;
    /**
     * 竞品 - 钱家香排面总数
     */
    private  Integer competitorQianjiaxiangFacingTotal;
    /**
     * 竞品 - 金厨娘 SKU 总数
     */
    private  Integer competitorJinchuniangSkuTotal;
    /**
     * 竞品 - 金厨娘排面总数
     */
    private  Integer competitorJinchuniangFacingTota;

    /**      竞品-结束       **/

//    自动填充
    private String operName;
    private String operEmpNo;
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date operDate;
    private TaskDetailVo taskDetail;
    /**
     * 常规陈列判定结果
     */
    private String[] cgclRiskRArr;
    /**
     * 档期陈列判定结果
     */
    private String[] dqclRiskRArr;

    @AllArgsConstructor
    @NoArgsConstructor
    @Data
    public static class TaskDetailVo{
        private Long rstId;
        private Long rstdId;
        /**
         * 明细类型（1:常规陈列，2:档期陈列，3:档期补差，4:品类信息）
         */
        private String detailName;

        /**
         * 陈列形式
         */
        private String modal;

        /**
         * 陈列费用
         */
        private BigDecimal cost;

        /**
         * 陈列/补差照片
         */
        private String[] photoArr;
        /**
         * 检核结果
         */
        private String[] riskRArr;

        /**
         * 补差内容
         */
        private String bcNr;

        /**
         * 补差情况
         */
        private String bcQk;

        /**
         * 虎皮210g价格
         */
        private String priceHp210;

        /**
         * 虎皮210g口味铺市月份
         */
        private Map<String,String> kwYmHp210Map;

        /**
         * 虎皮105g价格
         */
        private String priceHp105;

        /**
         * 虎皮105g口味铺市月份
         */
        private Map<String,String> kwYmHp105Map;

        /**
         * 虎皮68g价格
         */
        private String priceHp68;

        /**
         * 虎皮68g口味铺市月份
         */
        private Map<String,String> kwYmHp68Map;

        /**
         * 鸡肉豆堡120g价格
         */
        private String priceJrdb120;

        /**
         * 鸡肉豆堡120g口味铺市月份
         */
        private Map<String,String> kwYmJrdb120Map;

        /**
         * 牛肉豆堡120g价格
         */
        private String priceNrdb120;

        /**
         * 牛肉豆堡120g口味铺市月份
         */
        private Map<String,String> kwYmNrdb120Map;

        /**
         * 去骨凤爪72g价格
         */
        private String priceQg72;

        /**
         * 去骨凤爪72g口味铺市月份
         */
        private Map<String,String> kwYmQg72Map;

        /**
         * 去骨凤爪138g价格
         */
        private String priceQg138;

        /**
         * 去骨凤爪138g口味铺市月份
         */
        private Map<String,String> kwYmQg138Map;

        /**
         * 虎皮小鸡腿80g价格
         */
        private String priceHpjt80;

        /**
         * 虎皮小鸡腿80g口味铺市月份
         */
        private Map<String,String> kwYmHpjt80Map;

        /**
         * 老卤价格
         */
        private String priceLl;

        /**
         * 老卤口味铺市月份
         */
        private Map<String,String> kwYmLlMap;

        /**
         * 虎皮单支价格
         */
        private String priceHpDz;

        /**
         * 虎皮单支口味铺市月份
         */
        private Map<String,String> kwYmHpDzMap;

        /**
         * 虎皮散称价格
         */
        private String priceHpSc;

        /**
         * 虎皮散称口味铺市月份
         */
        private Map<String,String> kwYmHpScMap;

    }
}
