package com.sfa.operation.domain.risk.dao.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.sfa.common.core.domain.dao.impl.BaseDaoImpl;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.WXLSQLException;
import com.sfa.common.core.utils.bean.BeanUtils;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.core.web.page.TableSupport;
import com.sfa.operation.domain.risk.dao.IRiskStoreTaskDao;
import com.sfa.operation.domain.risk.entity.RiskStoreTask;
import com.sfa.operation.domain.risk.entity.RiskStoreTaskDetail;
import com.sfa.operation.domain.risk.mapper.RiskStoreTaskDetailMapper;
import com.sfa.operation.domain.risk.mapper.RiskStoreTaskMapper;
import com.sfa.operation.domain.risk.wq.RiskStoreTaskWq;
import com.sfa.operation.pojo.risk.response.RiskStoreTaskDto;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author : liqiulin
 * @date : 2025-08-27 20
 * @describe :
 */
@DS("bi")
@Repository
public class RiskStoreTaskDaoImpl extends BaseDaoImpl<RiskStoreTask> implements IRiskStoreTaskDao {
    @Autowired
    private RiskStoreTaskMapper riskStoreTaskMapper;
    @Autowired
    private RiskStoreTaskDetailMapper riskStoreTaskDetailMapper;
    @Override
    public RiskStoreTaskDto insert(RiskStoreTaskDto taskDto) {
        try {
            RiskStoreTask taskDo = BeanUtils.transitionDto(taskDto, RiskStoreTask.class);
            taskDo.setCreateDate(new Date());
            riskStoreTaskMapper.insert(taskDo);
            taskDto.setRstId(taskDo.getRstId());
            return taskDto;
        }catch (Exception e){
            String eMsg = e.getCause().getMessage();
            if (eMsg.contains("for key 'user_task'")) {
                throw new WXLSQLException(ECode.DB_TABLE_UNIQUE_EXIST, "今日此售点任务");
            }
            throw new WXLSQLException(ECode.DB_TABLE_UPDATE_ERROR);
        }
    }

    @Override
    public PageInfo page(RiskStoreTaskWq wq) {
        LambdaQueryWrapper<RiskStoreTask> rqw = buildWq(wq);
        Page<RiskStoreTask> pageDos = riskStoreTaskMapper.selectPage(TableSupport.pageI(), rqw);
        return new PageInfo(pageDos);
    }

    @Override
    public RiskStoreTaskDto updateInspectStore(RiskStoreTaskDto taskDto) {
        RiskStoreTask taskDo = BeanUtils.transitionDto(taskDto, RiskStoreTask.class);
        riskStoreTaskMapper.updateById(taskDo);
        RiskStoreTask riskStoreTask = riskStoreTaskMapper.selectById(taskDo.getRstId());
        RiskStoreTaskDto tDto = BeanUtils.transitionDto(riskStoreTask, RiskStoreTaskDto.class);
        tDto.tranArr();
        return tDto;
    }

    @Override
    public RiskStoreTaskDto selectOne(RiskStoreTaskWq wq) {
        LambdaQueryWrapper<RiskStoreTask> rqw = buildWq(wq);
        RiskStoreTask riskStoreTask = riskStoreTaskMapper.selectOne(rqw);
        if (Objects.isNull(riskStoreTask)){
            return null;
        }
        RiskStoreTaskDto tDto = BeanUtils.transitionDto(riskStoreTask, RiskStoreTaskDto.class);
        tDto.tranArr();
        List<RiskStoreTaskDetail> riskStoreTaskDetails = riskStoreTaskDetailMapper.selectList(new LambdaQueryWrapper<RiskStoreTaskDetail>().eq(RiskStoreTaskDetail::getRstId, riskStoreTask.getRstId()));
        if (CollectionUtils.isEmpty(riskStoreTaskDetails)){
            return tDto;
        }
        // 返回任务明细
        List<RiskStoreTaskDto.RiskStoreTaskDetailDto> taskDetailDtos = BeanUtils.transitionDtos(riskStoreTaskDetails, RiskStoreTaskDto.RiskStoreTaskDetailDto.class);
        taskDetailDtos.forEach(detailDto -> rDetail(detailDto));
        Map<String, List<RiskStoreTaskDto.RiskStoreTaskDetailDto>> detailMap = taskDetailDtos.stream().collect(Collectors.groupingBy(RiskStoreTaskDto.RiskStoreTaskDetailDto::getDetailName));
        tDto.setDetailMap(detailMap);
        return tDto;
    }

    @Override
    public RiskStoreTaskDto.RiskStoreTaskDetailDto saveStoreDetail(Long rstId, String detailName) {
        RiskStoreTaskDetail taskDetailDo = new RiskStoreTaskDetail();
        taskDetailDo.setRstId(rstId);
        taskDetailDo.setDetailName(detailName);
        riskStoreTaskDetailMapper.insert(taskDetailDo);
        return BeanUtils.transitionDto(taskDetailDo, RiskStoreTaskDto.RiskStoreTaskDetailDto.class);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public RiskStoreTaskDto.RiskStoreTaskDetailDto updateStoreDetail(RiskStoreTaskDto.RiskStoreTaskDetailDto riskStoreTaskDetailDto) {
        RiskStoreTaskDetail detailDo = BeanUtils.transitionDto(riskStoreTaskDetailDto, RiskStoreTaskDetail.class);
        riskStoreTaskDetailMapper.updateById(detailDo);
        updateDetail(detailDo.getRstId());
        RiskStoreTaskDetail riskStoreTaskDetail = riskStoreTaskDetailMapper.selectById(detailDo.getRstdId());
        RiskStoreTaskDto.RiskStoreTaskDetailDto tDto = BeanUtils.transitionDto(riskStoreTaskDetail, RiskStoreTaskDto.RiskStoreTaskDetailDto.class);
        rDetail(tDto);
        return tDto;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void deleteStoreDetail(Long rstdId) {
        RiskStoreTaskDetail detailDo = riskStoreTaskDetailMapper.selectById(rstdId);
        riskStoreTaskDetailMapper.deleteById(rstdId);
        updateDetail(detailDo.getRstId());
    }

    private LambdaQueryWrapper<RiskStoreTask> buildWq(RiskStoreTaskWq wq) {
        LambdaQueryWrapper<RiskStoreTask> wqWrapper = new LambdaQueryWrapper<>();
        if (Objects.nonNull(wq.getRstId())){
            wqWrapper.eq(RiskStoreTask::getRstId, wq.getRstId());
        }
        if (StringUtils.isNotBlank(wq.getStoreName())){
            wqWrapper.like(RiskStoreTask::getStoreName, wq.getStoreName());
        }
        if (StringUtils.isNotBlank(wq.getStoreCode())){
            wqWrapper.eq(RiskStoreTask::getStoreCode, wq.getStoreCode());
        }
        if (StringUtils.isNotBlank(wq.getOperEmpNo())){
            wqWrapper.eq(RiskStoreTask::getCreateEmpNo, wq.getOperEmpNo());
        }
        if (Objects.nonNull(wq.getOperDate())){
            wqWrapper.eq(RiskStoreTask::getCreateDate, wq.getOperDate());
        }
        // 按照范围查询
        wqWrapper.between(ObjectUtil.isAllNotEmpty(wq.getOperDateStart(),wq.getOperDateEnd()),RiskStoreTask::getCreateDate,wq.getOperDateStart(),wq.getOperDateEnd());
        wqWrapper.orderByDesc(RiskStoreTask::getCreateTime);
        return wqWrapper;
    }
    private void rDetail(RiskStoreTaskDto.RiskStoreTaskDetailDto tDto) {
        tDto.setPhotoArr(StringUtils.isBlank(tDto.getPhotos()) ? null : tDto.getPhotos().split(","));
        tDto.setRiskRArr(StringUtils.isBlank(tDto.getRiskR()) ? null : tDto.getRiskR().split(","));
        tDto.setKwYmHp210Map(StringUtils.isBlank(tDto.getKwYmHp210()) ? null : JSONObject.parseObject(tDto.getKwYmHp210(), Map.class));
        tDto.setKwYmHp105Map(StringUtils.isBlank(tDto.getKwYmHp105()) ? null : JSONObject.parseObject(tDto.getKwYmHp105(), Map.class));
        tDto.setKwYmHp68Map(StringUtils.isBlank(tDto.getKwYmHp68()) ? null : JSONObject.parseObject(tDto.getKwYmHp68(), Map.class));
        tDto.setKwYmJrdb120Map(StringUtils.isBlank(tDto.getKwYmJrdb120()) ? null : JSONObject.parseObject(tDto.getKwYmJrdb120(), Map.class));
        tDto.setKwYmNrdb120Map(StringUtils.isBlank(tDto.getKwYmNrdb120()) ? null : JSONObject.parseObject(tDto.getKwYmNrdb120(), Map.class));
        tDto.setKwYmQg72Map(StringUtils.isBlank(tDto.getKwYmQg72()) ? null : JSONObject.parseObject(tDto.getKwYmQg72(), Map.class));
        tDto.setKwYmQg138Map(StringUtils.isBlank(tDto.getKwYmQg138()) ? null : JSONObject.parseObject(tDto.getKwYmQg138(), Map.class));
        tDto.setKwYmHpjt80Map(StringUtils.isBlank(tDto.getKwYmHpjt80()) ? null : JSONObject.parseObject(tDto.getKwYmHpjt80(), Map.class));
        tDto.setKwYmLlMap(StringUtils.isBlank(tDto.getKwYmLl()) ? null : JSONObject.parseObject(tDto.getKwYmLl(), Map.class));
        tDto.setKwYmHpDzMap(StringUtils.isBlank(tDto.getKwYmHpDz()) ? null : JSONObject.parseObject(tDto.getKwYmHpDz(), Map.class));
        tDto.setKwYmHpScMap(StringUtils.isBlank(tDto.getKwYmHpSc()) ? null : JSONObject.parseObject(tDto.getKwYmHpSc(), Map.class));
    }

    private void updateDetail(Long rstId) {
        // 查询最新数据，回写RiskStoreTask表
        RiskStoreTask riskStoreTask = riskStoreTaskMapper.selectById(rstId);
        riskStoreTask.detailInit();
        List<RiskStoreTaskDetail> details = riskStoreTaskDetailMapper.selectList(new LambdaQueryWrapper<RiskStoreTaskDetail>().eq(RiskStoreTaskDetail::getRstId, rstId).orderByAsc(RiskStoreTaskDetail::getRstdId));
        Map<String, List<RiskStoreTaskDetail>> detailMap = details.stream().collect(Collectors.groupingBy(RiskStoreTaskDetail::getDetailName));

        // 常规陈列、档期补差、档期陈列、品类信息
        List<RiskStoreTaskDetail> cgcls = detailMap.get("常规陈列");
        if (!CollectionUtils.isEmpty(cgcls)){
            if (cgcls.size() >= 1){
                RiskStoreTaskDetail cgcl = cgcls.get(0);
                riskStoreTask.setDModal1(cgcl.getModal());
                riskStoreTask.setDCost1(cgcl.getCost());
                riskStoreTask.setDPhotos1(cgcl.getPhotos());
                riskStoreTask.setDRiskR1(cgcl.getRiskR());
            }
            if (cgcls.size() >= 2){
                RiskStoreTaskDetail cgcl = cgcls.get(1);
                riskStoreTask.setDModal2(cgcl.getModal());
                riskStoreTask.setDCost2(cgcl.getCost());
                riskStoreTask.setDPhotos2(cgcl.getPhotos());
                riskStoreTask.setDRiskR2(cgcl.getRiskR());
            }
            if (cgcls.size() >= 3){
                RiskStoreTaskDetail cgcl = cgcls.get(2);
                riskStoreTask.setDModal3(cgcl.getModal());
                riskStoreTask.setDCost3(cgcl.getCost());
                riskStoreTask.setDPhotos3(cgcl.getPhotos());
                riskStoreTask.setDRiskR3(cgcl.getRiskR());
            }

        }

        List<RiskStoreTaskDetail> dqbcs = detailMap.get("档期补差");
        if (!CollectionUtils.isEmpty(dqbcs)){
            if (dqbcs.size() >= 1){
                RiskStoreTaskDetail dqbc = dqbcs.get(0);
                riskStoreTask.setBcNr1(dqbc.getBcNr());
                riskStoreTask.setBcQk1(dqbc.getBcQk());
                riskStoreTask.setBcPhotos1(dqbc.getPhotos());
                riskStoreTask.setBcRiskR1(dqbc.getRiskR());
            }
            if (dqbcs.size() >= 2){
                RiskStoreTaskDetail dqbc = dqbcs.get(1);
                riskStoreTask.setBcNr2(dqbc.getBcNr());
                riskStoreTask.setBcQk2(dqbc.getBcQk());
                riskStoreTask.setBcPhotos2(dqbc.getPhotos());
                riskStoreTask.setBcRiskR2(dqbc.getRiskR());
            }
            if (dqbcs.size() >= 3){
                RiskStoreTaskDetail dqbc = dqbcs.get(2);
                riskStoreTask.setBcNr3(dqbc.getBcNr());
                riskStoreTask.setBcQk3(dqbc.getBcQk());
                riskStoreTask.setBcPhotos3(dqbc.getPhotos());
                riskStoreTask.setBcRiskR3(dqbc.getRiskR());
            }
        }

        List<RiskStoreTaskDetail> dqcls = detailMap.get("档期陈列");
        if (!CollectionUtils.isEmpty(dqcls)){
            if (dqcls.size() >= 1){
                RiskStoreTaskDetail dqcl = dqcls.get(0);
                riskStoreTask.setPModal1(dqcl.getModal());
                riskStoreTask.setPCost1(dqcl.getCost());
                riskStoreTask.setPPhotos1(dqcl.getPhotos());
                riskStoreTask.setPRiskR1(dqcl.getRiskR());
            }
            if (dqcls.size() >= 2){
                RiskStoreTaskDetail dqcl = dqcls.get(1);
                riskStoreTask.setPModal2(dqcl.getModal());
                riskStoreTask.setPCost2(dqcl.getCost());
                riskStoreTask.setPPhotos2(dqcl.getPhotos());
                riskStoreTask.setPRiskR2(dqcl.getRiskR());
            }
            if (dqcls.size() >= 3){
                RiskStoreTaskDetail dqcl = dqcls.get(2);
                riskStoreTask.setPModal3(dqcl.getModal());
                riskStoreTask.setPCost3(dqcl.getCost());
                riskStoreTask.setPPhotos3(dqcl.getPhotos());
                riskStoreTask.setPRiskR3(dqcl.getRiskR());
            }
        }
        List<RiskStoreTaskDetail> plxxs = detailMap.get("品类信息");
        if (!CollectionUtils.isEmpty(plxxs)){
            RiskStoreTaskDetail plxx = plxxs.get(0);
            riskStoreTask.setPriceHp210(plxx.getPriceHp210());
            riskStoreTask.setKwYmHp210(plxx.getKwYmHp210());
            riskStoreTask.setPriceHp105(plxx.getPriceHp105());
            riskStoreTask.setKwYmHp105(plxx.getKwYmHp105());
            riskStoreTask.setPriceHp68(plxx.getPriceHp68());
            riskStoreTask.setKwYmHp68(plxx.getKwYmHp68());
            riskStoreTask.setPriceJrdb120(plxx.getPriceJrdb120());
            riskStoreTask.setKwYmJrdb120(plxx.getKwYmJrdb120());
            riskStoreTask.setPriceNrdb120(plxx.getPriceNrdb120());
            riskStoreTask.setKwYmNrdb120(plxx.getKwYmNrdb120());
            riskStoreTask.setPriceQg72(plxx.getPriceQg72());
            riskStoreTask.setKwYmQg72(plxx.getKwYmQg72());
            riskStoreTask.setPriceQg138(plxx.getPriceQg138());
            riskStoreTask.setKwYmQg138(plxx.getKwYmQg138());
            riskStoreTask.setPriceHpjt80(plxx.getPriceHpjt80());
            riskStoreTask.setKwYmHpjt80(plxx.getKwYmHpjt80());
            riskStoreTask.setPriceLl(plxx.getPriceLl());
            riskStoreTask.setKwYmLl(plxx.getKwYmLl());
            riskStoreTask.setPriceHpDz(plxx.getPriceHpDz());
            riskStoreTask.setKwYmHpDz(plxx.getKwYmHpDz());
            riskStoreTask.setPriceHpSc(plxx.getPriceHpSc());
            riskStoreTask.setKwYmHpSc(plxx.getKwYmHpSc());
        }
        riskStoreTaskMapper.updateDetailById(riskStoreTask);
    }



}
