package com.sfa.operation.service.sales.impl;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import com.sfa.common.core.utils.bean.BeanUtils;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.operation.domain.sales.dao.*;
import com.sfa.operation.domain.sales.entity.SalesApDisplay;
import com.sfa.operation.domain.sales.entity.SalesApPromotion;
import com.sfa.operation.domain.sales.entity.SalesApSnacksDisplay;
import com.sfa.operation.domain.sales.wq.SalesApWq;
import com.sfa.operation.pojo.sales.excel.SalesApDisplayImportExcelDto;
import com.sfa.operation.pojo.sales.request.SalesApRequest;
import com.sfa.operation.service.sales.IApDisplayQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;

/**
 * @author : liqiulin
 * @date : 2025-09-08 14
 * @describe :
 */
@Service
public class ApDisplayQueryServiceImpl implements IApDisplayQueryService {
    @Autowired
    private ISalesApDisplayDao salesApDisplayDao;
    @Autowired
    private ISalesApPromotionDisplayDao salesApPromotionDisplayDao;
    @Autowired
    private ISalesApSnacksDisplayDao salesapsnackdsDisplayDao;
    @Autowired
    private ISalesApDisplaySDao salesApDisplaySDao;
    @Autowired
    private ISalesApDisplayJDao salesApDisplayJDao;
    @Autowired
    private ISalesApPromotionDao salesApPromotionDao;

    @Override
    public PageInfo page(SalesApRequest salesApRequest) {
        return salesApDisplayDao.page(build(salesApRequest));
    }

    @Override
    public PageInfo proPage(SalesApRequest salesApRequest) {
        return salesApPromotionDisplayDao.page(build(salesApRequest));
    }

    @Override
    public PageInfo snackPage(SalesApRequest salesApRequest) {
        return salesapsnackdsDisplayDao.page(build(salesApRequest));
    }

    @Override
    public PageInfo slPage(SalesApRequest salesApRequest) {
        return salesApDisplaySDao.page(build(salesApRequest));
    }

    @Override
    public PageInfo jgPage(SalesApRequest salesApRequest) {
        return salesApDisplayJDao.page(build(salesApRequest));
    }

    @Override
    public PageInfo promotionPage(SalesApRequest salesApRequest) {
        return salesApPromotionDao.page(build(salesApRequest));
    }

    @Override
    public Object queryStoreAPReport(SalesApRequest salesApRequest) {
        return salesApDisplayDao.queryStoreAPReport(build(salesApRequest));
    }

    @Override
    public Object queryDeptAPReport(SalesApRequest request) {
        return salesApDisplayDao.queryDeptAPReport(build(request));
    }

    @Override
    public Object queryDistAPReport(SalesApRequest request) {
        return salesApDisplayDao.queryDistAPReport(build(request));
    }

    /**
     * 导入导出根据条件查询
     * @param request 请求参数
     * @return  List
     */
    @Override
    public List<SalesApDisplay> queryDataListByCondition(SalesApRequest request) {
        return salesApDisplayDao.queryDataListByCondition(build(request));
    }

    /**
     * 导入数据时 根据DTO的内容批量查询数据
     * @param validDtoList
     * @return
     */
    @Override
    public List<SalesApDisplay> queryByCondition(List<SalesApDisplayImportExcelDto> validDtoList) {
        return salesApDisplayDao.queryByCondition(validDtoList);
    }

    /**
     * 根据条件查询零食陈列
     * @param request
     * @return  List
     */
    @Override
    public List<SalesApSnacksDisplay> querySnackByCondition(SalesApRequest request) {
        return salesapsnackdsDisplayDao.querySnackByCondition(build(request));
    }

    @Override
    public List<SalesApPromotion> queryPromotionDisplayByCondition(SalesApRequest request) {
        return salesApPromotionDao.queryPromotionDisplayByCondition(build(request));
    }

    private SalesApWq build(SalesApRequest salesApRequest){
        SalesApWq salesApWq = new SalesApWq();
        BeanUtils.copyProperties(salesApRequest,salesApWq);
        salesApWq.setSalesMonth(salesApRequest.getSalesMonth() != null ? DateUtil.parse(salesApRequest.getSalesMonth() + "-01", DatePattern.NORM_DATE_PATTERN) : null);
        return salesApWq;
    }

}
