package com.sfa.operation.domain.sales.wq;

import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author : liqiulin
 * @date : 2025-09-16 14
 * @describe :
 */
@Data
public class SalesApWq {
    private String dealerCode;
    private Date salesMonth;
    private String cityManager;
    /**
     * 前端搜索条件：大区/战区
     */
    private String deptName;
    /**
     * 根据登录人，默认重置大区/战区信息
     * 与deptName，不冲突
     */
    private List<String> deptNames;
    private String nickName;
    private List<String> dealerCodes;
    private String dealerCodeStrs;
    /**
     * 经销商编码（精准）/名称（模糊）
     */
    private String dealerCN;
    /**
     * 门店编码（精准）/名称（模糊）
     */
    private String storeCN;
    /**
     * 系统名称
     */
    private String lineNameLike;
    /**
     * 登录人工号
     */
    private String empNo;
    /**
     * 部门编码
     */
    private String deptCode;

    /**
     * 任务状态 未执行/""
     * 未执行：返回所有状态是未执行的
     * ""（空）：不筛选状态
     */
    private String rqStatus;
}
