package com.sfa.operation.controller.zzhao.query;

/**
 * @author : liqiulin
 * @date : 2025-10-30 18
 * @describe :
 */

import com.sfa.common.core.constant.RoleConstants;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.CheckedException;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.security.utils.SecurityUtils;
import com.sfa.operation.pojo.zzhao.request.ZzProductQualityVo;
import com.sfa.operation.service.zzhao.IZzProQualityQueryService;
import com.sfa.system.api.domain.SysRole;
import com.sfa.system.api.domain.SysUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Optional;

/**
 * @author : liqiulin
 * @date : 2025-10-30 15
 * @describe :
 */
@RestController
@RequestMapping("/zzhao/query/proQuality")
public class ZzProQualityQueryController {
    @Autowired
    private IZzProQualityQueryService zzProQualityQueryService;

    @GetMapping("/page")
    public PageInfo page(ZzProductQualityVo vo){
        // 判断当前角色数据权限，当前部门或全部部门
        SysUser sysUser = SecurityUtils.getLoginUser().getSysUser();
        List<SysRole> roles = sysUser.getRoles();
        if (!sysUser.isAdmin()) {
            if (CollectionUtils.isEmpty(roles)) {
                throw new CheckedException(ECode.ROLE_ERROR);
            }
            Optional<SysRole> first = roles.stream().filter(role -> RoleConstants.PRODUCT_QUALITY_CHECK.equals(role.getRoleKey())).findFirst();
            if (first.isPresent()) {
                SysRole sysRole = first.get();
                String dataScope = sysRole.getDataScope();
                // 判断数据范围
                if (RoleConstants.DATA_SCOPE_DEPT.equals(dataScope)) {
                    Long deptId = sysUser.getDeptId();
                    vo.setDeptId(deptId);
                }
            }
        }
        return zzProQualityQueryService.page(vo);
    }
}
