package com.sfa.operation.service.sfa.impl;

import cn.hutool.core.date.DateUtil;
import com.sfa.common.core.constant.SecurityConstants;
import com.sfa.common.core.utils.DateUtils;
import com.sfa.common.security.utils.SecurityUtils;
import com.sfa.operation.domain.sfa.dao.ISfaKqmxDao;
import com.sfa.operation.enums.KqEnum;
import com.sfa.operation.pojo.sfa.response.SfaKqMxDto;
import com.sfa.operation.service.sfa.IKqMxQueryService;
import com.sfa.system.api.RemoteKqRuleService;
import com.sfa.system.api.pojo.response.MdmKqRuleDto;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author : liqiulin
 * @date : 2024-11-05 14
 * @describe :
 */
@Service
public class KqMxQueryServiceImpl implements IKqMxQueryService {
    @Autowired
    ISfaKqmxDao sfaKqmxDao;
    @Autowired
    RemoteKqRuleService remoteKqRuleService;

    @Override
    public Map rollDateList( Date dateStart,Long userId) {
        Long ruleId = SecurityUtils.getLoginUser().getRuleId();
        MdmKqRuleDto kqruleDto = remoteKqRuleService.getInfo(ruleId, SecurityConstants.INNER).getData();
        List<SfaKqMxDto> dtos = sfaKqmxDao.betweentDate(dateStart,userId);
        TreeMap<String, List<SfaKqMxDto>> gm = dtos.stream().collect(Collectors.groupingBy(item -> new SimpleDateFormat(DateUtils.YYYY_MM_DD).format(item.getCreateDate()), TreeMap::new, Collectors.toList()));

        // 判断无考勤，或下标0非今天时，创建今日数据
        String today = DateUtil.today();
        boolean hasSec = Objects.nonNull(kqruleDto.getSecBegintime());
        int clockNum = Objects.nonNull(kqruleDto.getSecBegintime()) ? 3 : 2;

        // 无需处理
        if (gm.containsKey(today) && (gm.get(today).size() == clockNum)) {
            return gm.descendingMap();
        }
        // 无今日明细
        if (MapUtils.isEmpty(gm) || !gm.containsKey(today)){
            List<SfaKqMxDto> mxDtos = new ArrayList<>();
            mxDtos.add(new SfaKqMxDto(KqEnum.FIR_CLOCK.getKqType()));
            if (hasSec){
                mxDtos.add(new SfaKqMxDto(KqEnum.SEC_CLOCK.getKqType()));
            }
            mxDtos.add(new SfaKqMxDto(KqEnum.THI_CLOCK.getKqType()));
            gm.put(today,mxDtos);
            return gm.descendingMap();
        }

        List<SfaKqMxDto> mxDtos = gm.get(today);

        if (mxDtos.size() < clockNum - 1) {
            mxDtos.add(new SfaKqMxDto(KqEnum.SEC_CLOCK.getKqType()));
        }
        mxDtos.add(new SfaKqMxDto(KqEnum.THI_CLOCK.getKqType()));
        return gm.descendingMap();
    }
}
