package com.sfa.operation.domain.sales.dao.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.sfa.common.core.utils.StringUtils;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.core.web.page.TableSupport;
import com.sfa.operation.domain.sales.dao.ISalesApPromotionDisplayDao;
import com.sfa.operation.domain.sales.entity.SalesApDisplay;
import com.sfa.operation.domain.sales.entity.SalesApPromotionDisplay;
import com.sfa.operation.domain.sales.mapper.SalesApPromotionDisplayMapper;
import com.sfa.operation.domain.sales.wq.SalesApWq;
import com.sfa.operation.pojo.sales.response.SalesApPromotionDisplayDto;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2025-09-26 13
 * @describe :
 */
@DS("bi")
@Service
public class SalesApPromotionDisplayDaoImpl implements ISalesApPromotionDisplayDao {
    @Autowired
    private SalesApPromotionDisplayMapper salesApPromotionDisplayMapper;
    @Override
    public PageInfo page(SalesApWq salesApWq) {
        LambdaQueryWrapper<SalesApPromotionDisplay> qw = buildWq(salesApWq);
        Page<SalesApPromotionDisplay> page = salesApPromotionDisplayMapper.selectPage(TableSupport.pageI(), qw);
        return new PageInfo<>(page);
    }

    @Override
    public void updateDetail(SalesApPromotionDisplayDto pdDto) {
        SalesApPromotionDisplay pd = new SalesApPromotionDisplay();
        BeanUtils.copyProperties(pdDto,pd);
        salesApPromotionDisplayMapper.updateById(pd);
    }

    private LambdaQueryWrapper<SalesApPromotionDisplay> buildWq(SalesApWq salesApWq) {
        LambdaQueryWrapper<SalesApPromotionDisplay> qw = new LambdaQueryWrapper<>();
        if (Objects.nonNull(salesApWq.getSalesMonth())){
            qw.eq(SalesApPromotionDisplay::getSalesMonth, salesApWq.getSalesMonth());
        }
        if (!CollectionUtils.isEmpty(salesApWq.getDealerCodes())) {
            qw.in(SalesApPromotionDisplay::getDealerCode, salesApWq.getDealerCodes());
        }
        if (StringUtils.isNotBlank(salesApWq.getDeptName())){
            qw.and(
                    wrapper -> wrapper.eq(SalesApPromotionDisplay::getRegionName, salesApWq.getDeptName())
                            .or()
                            .eq(SalesApPromotionDisplay::getDistrictName, salesApWq.getDeptName())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getNickName())){
            qw.and(
                    wrapper -> wrapper.eq(SalesApPromotionDisplay::getRegionManager, salesApWq.getNickName())
                            .or()
                            .eq(SalesApPromotionDisplay::getDistrictManager, salesApWq.getNickName())
                            .or()
                            .eq(SalesApPromotionDisplay::getCityManager, salesApWq.getNickName())
            );
        }
        return qw;
    }
}
