package com.sfa.operation.controller.risk.core;

import com.alibaba.fastjson2.JSONObject;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.CheckedException;
import com.sfa.common.security.utils.SecurityUtils;
import com.sfa.operation.pojo.risk.request.RiskStoreTaskVo;
import com.sfa.operation.pojo.risk.response.RiskInspectStoreDto;
import com.sfa.operation.pojo.risk.response.RiskStoreTaskDto;
import com.sfa.operation.service.risk.IRiskStoreCoreService;
import com.sfa.operation.service.risk.IRiskStoreTaskCoreService;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.Map;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2025-08-27 20
 * @describe : 风控中心-售点稽查
 */
@RestController
@RequestMapping("/risk/core")
public class RiskStoreTaskCoreController {
    @Autowired
    private IRiskStoreTaskCoreService riskstoreTaskCoreService;
    @Autowired
    private IRiskStoreCoreService riskstoreCoreService;
    @PostMapping("/i_store")
    public RiskStoreTaskDto inspectStore(@RequestBody RiskStoreTaskVo riskStoreTaskVo) {
        if (riskStoreTaskVo.getRstId() == null &&StringUtils.isBlank(riskStoreTaskVo.getStoreName())){
            throw new CheckedException(ECode.RISK_STORE_TASK_CREATE_ERROR);
        }
        riskStoreTaskVo.setOperName(SecurityUtils.getNickName());
        riskStoreTaskVo.setOperEmpNo(SecurityUtils.getUsername());
        // 保存来源勤策的门店
        if (Objects.nonNull(riskStoreTaskVo.getStoreCode())){
            RiskInspectStoreDto storeDto = riskstoreCoreService.saveInspectStore(riskStoreTaskVo);
            riskStoreTaskVo.setStoreName(StringUtils.isNotBlank(storeDto.getRStoreName()) ? storeDto.getRStoreName() : riskStoreTaskVo.getStoreName());
        }

        RiskStoreTaskDto dto = null;
        // 是否新建
        if (Objects.isNull(riskStoreTaskVo.getRstId())){
            dto = riskstoreTaskCoreService.inspectStore(riskStoreTaskVo);
        }else {
            riskStoreTaskVo.setStoreName(StringUtils.isNotBlank(riskStoreTaskVo.getRStoreName()) ? riskStoreTaskVo.getRStoreName() : riskStoreTaskVo.getStoreName());
            RiskStoreTaskDto taskDto = new RiskStoreTaskDto();
            BeanUtils.copyProperties(riskStoreTaskVo,taskDto);
            taskDto.setUpdateBy(riskStoreTaskVo.getOperName());
            taskDto.setLhlds(pArr(riskStoreTaskVo.getLhldArr()));
            taskDto.setCgclRiskR(pArr(riskStoreTaskVo.getCgclRiskRArr()));
            taskDto.setDqclRiskR(pArr(riskStoreTaskVo.getDqclRiskRArr()));
            taskDto.setLongTimePictures(pArr(riskStoreTaskVo.getLongTimePictureArr()));
            dto = riskstoreTaskCoreService.updateInspectStore(taskDto);
        }
        return dto;
    }

    @PostMapping("/i_store_detail")
    public RiskStoreTaskDto.RiskStoreTaskDetailDto inspectStoreDetail(@RequestBody RiskStoreTaskVo riskStoreTaskVo) {
        RiskStoreTaskVo.TaskDetailVo taskDetailVo = riskStoreTaskVo.getTaskDetail();
        if (Objects.isNull(taskDetailVo.getRstdId())){
            return riskstoreTaskCoreService.saveStoreDetail(taskDetailVo);
        }
        // 更新稽核详情
        RiskStoreTaskDto.RiskStoreTaskDetailDto riskStoreTaskDetailDto = new RiskStoreTaskDto.RiskStoreTaskDetailDto();
        BeanUtils.copyProperties(taskDetailVo,riskStoreTaskDetailDto);
        riskStoreTaskDetailDto.setPhotos(pArr(taskDetailVo.getPhotoArr()));
        riskStoreTaskDetailDto.setRiskR(pArr(taskDetailVo.getRiskRArr()));
        riskStoreTaskDetailDto.setKwYmHp210(mArr(taskDetailVo.getKwYmHp210Map()));
        riskStoreTaskDetailDto.setKwYmHp105(mArr(taskDetailVo.getKwYmHp105Map()));
        riskStoreTaskDetailDto.setKwYmHp68(mArr(taskDetailVo.getKwYmHp68Map()));
        riskStoreTaskDetailDto.setKwYmJrdb120(mArr(taskDetailVo.getKwYmJrdb120Map()));
        riskStoreTaskDetailDto.setKwYmNrdb120(mArr(taskDetailVo.getKwYmNrdb120Map()));
        riskStoreTaskDetailDto.setKwYmQg72(mArr(taskDetailVo.getKwYmQg72Map()));
        riskStoreTaskDetailDto.setKwYmQg138(mArr(taskDetailVo.getKwYmQg138Map()));
        riskStoreTaskDetailDto.setKwYmHpjt80(mArr(taskDetailVo.getKwYmHpjt80Map()));
        riskStoreTaskDetailDto.setKwYmLl(mArr(taskDetailVo.getKwYmLlMap()));
        riskStoreTaskDetailDto.setKwYmHpDz(mArr(taskDetailVo.getKwYmHpDzMap()));
        riskStoreTaskDetailDto.setKwYmHpSc(mArr(taskDetailVo.getKwYmHpScMap()));
        return riskstoreTaskCoreService.updateStoreDetail(riskStoreTaskDetailDto);
    }

    @DeleteMapping("/d_store_detail")
    public void deleteStoreDetail(Long rstdId) {
        riskstoreTaskCoreService.deleteStoreDetail(rstdId);
    }

    private String pArr(String[] dArr){
        return dArr == null ? null : dArr.length == 0 ? "" : StringUtils.join(dArr, ",");
    }

    private String mArr(Map<String,String> dMap){
        return dMap == null ? null : dMap.size() == 0 ? "" : JSONObject.toJSONString(dMap);
    }
}
