package com.sfa.operation.service.kq.impl;

import com.sfa.common.core.constant.SecurityConstants;
import com.sfa.common.core.domain.R;
import com.sfa.operation.domain.kq.dao.ISfaKqmxDao;
import com.sfa.operation.pojo.kq.response.SfaKqMxDto;
import com.sfa.operation.service.kq.IKqMxCoreService;
import com.sfa.system.api.RemoteSiteService;
import com.sfa.system.api.pojo.response.SiteDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-11-04 18
 * @describe : 
 */
@Service
public class KqMxCoreServiceImpl implements IKqMxCoreService {

    @Autowired
    RemoteSiteService remoteSiteService;
    @Autowired
    ISfaKqmxDao kqmxDao;

    @Override
    public void kqClockIn(SfaKqMxDto kqMxDto) {
        SiteDto siteDto = new SiteDto()
                .setProvinceName(kqMxDto.getKqProvinc())
                .setCityName(kqMxDto.getKqCity())
                .setCountyName(kqMxDto.getKqCounty());

        R<SiteDto> siteDtoR = remoteSiteService.getCountyName(siteDto, SecurityConstants.INNER);
        if (!Objects.isNull(siteDtoR.getData())){
            SiteDto data = siteDtoR.getData();
            kqMxDto.setKqProvinceNum(data.getProvinceNum())
                    .setKqCityNum(data.getCityNum())
                    .setKqCountyNum(data.getCountyNum());
        }
        kqmxDao.add(kqMxDto);
    }
}
