package com.sfa.operation.domain.kq.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * sfa考勤明细表
 * @TableName sfa_kqmx
 */
@AllArgsConstructor
@NoArgsConstructor
@TableName(value ="sfa_kqmx")
@Data
public class SfaKqmx implements Serializable {
    /**
     * 考勤明细ID
     */
    @TableId(type = IdType.AUTO)
    private Long kqmxId;

    /**
     * 员工ID
     */
    private Long kqUserid;

    /**
     * 考勤规则ID
     */
    private Long ruleId;

    /**
     * 考勤规则名称
     */
    private String ruleName;

    /**
     * 上班打卡时间
     */
    private Date kqTime;

    /**
     * 经度
     */
    private BigDecimal kqLon;

    /**
     * 纬度
     */
    private BigDecimal kqLat;


    /**
     * 打卡-省-市-区-详细地址
     */
    private String kqAddress;

    /**
     * 打卡省编码
     */
    private String kqProvinceNum;

    /**
     * 打卡省编码
     */
    private String kqProvinc;

    /**
     * 打卡城市编码
     */
    private String kqCityNum;

    /**
     * 打卡市编码
     */
    private String kqCity;

    /**
     * 打卡县/区编码
     */
    private String kqCountyNum;

    /**
     * 打卡区编码
     */
    private String kqCounty;

    /**
     * 考勤照片
     */
    private String kqPicurl;

    /**
     * 1:上班;2:午班;3:下班;
     */
    private Integer kqType;

    private Date createDate;

    /**
     * 记录版本
     */
    private Integer flag;

    /**
     * 记录删除
     */
    private String delFlag;

    /**
     * 创建者/打卡人员
     */
    private String createBy;

    /**
     * 创建人UserID
     */
    private Long createUserId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新者
     */
    private String updateBy;

    /**
     * 修改人UserID
     */
    private Long updateUserId;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 备注
     */
    private String remark;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}