package com.sfa.operation.domain.kq.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.WXLSQLException;
import com.sfa.operation.domain.kq.dao.ISfaKqmxDao;
import com.sfa.operation.domain.kq.entity.SfaKqmx;
import com.sfa.operation.domain.kq.mapper.SfaKqmxMapper;
import com.sfa.operation.pojo.kq.response.SfaKqMxDto;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-11-05 10
 * @describe :
 */
@Service
public class SfaKqmxDaoImpl implements ISfaKqmxDao {

    @Autowired
    SfaKqmxMapper sfaKqmxMapper;

    @Override
    public void add(SfaKqMxDto kqMxDto) {
        try {
            SfaKqmx kqDo = new SfaKqmx();
            BeanUtils.copyProperties(kqMxDto,kqDo);
            kqDo.setKqLon(kqMxDto.getKqLocal()[0]);
            kqDo.setKqLat(kqMxDto.getKqLocal()[1]);
            sfaKqmxMapper.insertOne(kqDo);
        }catch (Exception e) {
            String eMsg = e.getCause().getMessage();
            if (eMsg.contains("for key 'date_type_unique'")) {
                throw new WXLSQLException(ECode.KQMX_CURRENTLY_TYPE_KQ_HAS);
            }else {
                throw new WXLSQLException(ECode.KQMX_CLOCK_IN_ERRPR);
            }
        }
    }

    @Override
    public List<SfaKqMxDto> betweentDate(Date dateStart, Long userId) {
        LambdaQueryWrapper<SfaKqmx> qw = new LambdaQueryWrapper<>();
        qw.ge(SfaKqmx::getCreateDate, dateStart);
        qw.eq(SfaKqmx::getCreateUserId,userId);
        qw.select(SfaKqmx::getCreateDate,SfaKqmx::getKqmxId,SfaKqmx::getKqTime,SfaKqmx::getKqAddress,SfaKqmx::getKqPicurl,SfaKqmx::getKqType);

        List<SfaKqmx> dos = sfaKqmxMapper.selectList(qw);
        List<SfaKqMxDto> dtos = com.sfa.common.core.utils.bean.BeanUtils.transitionDtos(dos, SfaKqMxDto.class);
        return dtos;
    }
}
