package com.sfa.operation.controller.promotion.cpcore;

import com.sfa.operation.service.promotion.ICpPlanQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDate;
import java.util.List;

/**
 * @author : liqiulin
 * @date : 2025-05-27 18
 * @describe : CP计划核心操作接口
 */
@RequestMapping("/cpplan")
@RestController
public class CpPlanQueryController {

    @Autowired
    private ICpPlanQueryService cpPlanQueryService;

    /**
     * 审批当月数据
     */
    @PostMapping("/approval")
    public List<String> createApproval(){
        LocalDate  now = LocalDate.now();
        int year = now.getYear();
        int monthValue = now.getMonthValue();
        return cpPlanQueryService.createApproval(year,monthValue);
    }
}
