package com.sfa.operation.domain.sales.dao.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.sfa.common.core.utils.StringUtils;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.core.web.page.TableSupport;
import com.sfa.operation.domain.sales.dao.ISalesApDisplaySDao;
import com.sfa.operation.domain.sales.entity.SalesApDisplayS;
import com.sfa.operation.domain.sales.mapper.SalesApDisplaySMapper;
import com.sfa.operation.domain.sales.wq.SalesApWq;
import com.sfa.operation.pojo.sales.response.SalesApDisplaySDto;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2025-11-21 13
 * @describe : 三米两秒表
 */
@DS("bi")
@Service
public class SalesApDisplaySDaoImpl implements ISalesApDisplaySDao {
    @Autowired
    private SalesApDisplaySMapper salesApDisplaySMapper;
    
    @Override
    public PageInfo page(SalesApWq wq) {
        LambdaQueryWrapper<SalesApDisplayS> qw = buildWq(wq);
        Page<SalesApDisplayS> salesApDisplaySPage = salesApDisplaySMapper.selectPage(TableSupport.pageI(), qw);
        return new PageInfo<>(salesApDisplaySPage);
    }

    @Override
    public void updateDetail(SalesApDisplaySDto dsDto) {
        SalesApDisplayS entity = new SalesApDisplayS();
        BeanUtils.copyProperties(dsDto, entity);
        salesApDisplaySMapper.updateById(entity);
    }


    private LambdaQueryWrapper<SalesApDisplayS> buildWq(SalesApWq salesApWq) {
        LambdaQueryWrapper<SalesApDisplayS> qw = new LambdaQueryWrapper<>();
        if (Objects.nonNull(salesApWq.getSalesMonth())){
            qw.eq(SalesApDisplayS::getSalesMonth, salesApWq.getSalesMonth());
        }
        if (StringUtils.isNotBlank(salesApWq.getRqStatus())){
            qw.eq(SalesApDisplayS::getDisplayQtyExecuted60, salesApWq.getRqStatus());
        }
        if (!CollectionUtils.isEmpty(salesApWq.getDealerCodes())) {
            qw.in(SalesApDisplayS::getDealerCode, salesApWq.getDealerCodes());
        }
        if (!CollectionUtils.isEmpty(salesApWq.getDeptNames())){
            qw.and(
                    wrapper -> wrapper.in(SalesApDisplayS::getRegionName, salesApWq.getDeptNames())
                            .or()
                            .in(SalesApDisplayS::getDistrictName, salesApWq.getDeptNames())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getNickName())){
            qw.and(
                    wrapper -> wrapper.eq(SalesApDisplayS::getRegionManager, salesApWq.getNickName())
                            .or()
                            .eq(SalesApDisplayS::getDistrictManager, salesApWq.getNickName())
                            .or()
                            .eq(SalesApDisplayS::getCityManager, salesApWq.getNickName())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getDealerCN())){
            qw.and(
                    wrapper -> wrapper.like(SalesApDisplayS::getDealerName, salesApWq.getDealerCN())
                            .or()
                            .like(SalesApDisplayS::getDealerCode, salesApWq.getDealerCN())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getStoreCN())){
            qw.and(
                    wrapper -> wrapper.like(SalesApDisplayS::getStoreName, salesApWq.getStoreCN())
                            .or()
                            .like(SalesApDisplayS::getStoreCode, salesApWq.getStoreCN())
            );
        }
        if (StringUtils.isNotBlank(salesApWq.getLineNameLike())){
            qw.like(SalesApDisplayS::getLineName, salesApWq.getLineNameLike());
        }
        return qw;
    }
}
