package com.sfa.operation.domain.sales.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * 六小金刚批发挂网执行表
 * @TableName sales_ap_display_j
 */
@TableName(value ="sales_ap_display_j")
@Data
public class SalesApDisplayJ implements Serializable {
    /**
     * 主键ID（自增）
     */
    @TableId(type = IdType.AUTO)
    private Long sadjId;

    /**
     * 陈列所属月份
     */
    private Date salesMonth;

    /**
     * 销售大区
     */
    private String regionName;

    /**
     * 销售战区
     */
    private String districtName;

    /**
     * 经销商-省份
     */
    private String dealerProvince;

    /**
     * 经销商-城市
     */
    private String dealerCity;

    /**
     * 经销商-代码
     */
    private String dealerCode;

    /**
     * 经销商名称
     */
    private String dealerName;

    /**
     * 大区总监
     */
    private String regionManager;

    /**
     * 战区经理
     */
    private String districtManager;

    /**
     * 城市经理
     */
    private String cityManager;

    /**
     * 门店编码
     */
    private String storeCode;

    /**
     * 门店名称
     */
    private String storeName;

    /**
     * 门店-省份
     */
    private String storeProvince;

    /**
     * 门店-城市
     */
    private String storeCity;

    /**
     * 系统名称
     */
    private String lineName;

    /**
     * 系统类型
     */
    private String lineType;

    /**
     * 渠道大类
     */
    private String channelDl;

    /**
     * 渠道小类
     */
    private String channelXl;

    /**
     * 门店类型
     */
    private String storeType;

    /**
     * 系统业态
     */
    private String lineLf;

    /**
     * 计划执行-六小金刚批发挂网
     */
    private String plannedGw6;

    /**
     * 实际执行-六小金刚批发挂网
     */
    private String actualGw6;

    /**
     * 六小金刚批发挂网陈列费
     */
    private BigDecimal totalCostGw6;

    /**
     * 六小金刚批发挂网-是否执行（Y=是，N=否）
     */
    private String gwExecuted6;

    /**
     * 六小金刚批发挂网目标网点数
     */
    private Integer gwSn6;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新者
     */
    private String updateBy;

    /**
     * 更新时间
     */
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}