package com.sfa.operation.domain.risk.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import lombok.Data;

/**
 * 风控门店任务-档期/补差/品类信息表
 * @TableName risk_store_task_detail
 */
@TableName(value ="risk_store_task_detail")
@Data
public class RiskStoreTaskDetail implements Serializable {
    /**
     * 主键ID
     */
    @TableId(type = IdType.AUTO)
    private Long rstdId;

    /**
     * risk_store_task表ID
     */
    private Long rstId;

    /**
     * 明细类型名称
     */
    private String detailName;

    /**
     * 陈列形式
     */
    private String modal;

    /**
     * 陈列费用
     */
    private BigDecimal cost;

    /**
     * 陈列/补差照片
     */
    private String photos;
    /**
     * 检核结果
     */
    private String riskR;

    /**
     * 补差内容
     */
    private String bcNr;

    /**
     * 补差情况
     */
    private String bcQk;

    /**
     * 虎皮210g价格
     */
    private String priceHp210;

    /**
     * 虎皮210g口味铺市月份
     */
    private String kwYmHp210;

    /**
     * 虎皮105g价格
     */
    private String priceHp105;

    /**
     * 虎皮105g口味铺市月份
     */
    private String kwYmHp105;

    /**
     * 虎皮68g价格
     */
    private String priceHp68;

    /**
     * 虎皮68g口味铺市月份
     */
    private String kwYmHp68;

    /**
     * 鸡肉豆堡120g价格
     */
    private String priceJrdb120;

    /**
     * 鸡肉豆堡120g口味铺市月份
     */
    private String kwYmJrdb120;

    /**
     * 牛肉豆堡120g价格
     */
    private String priceNrdb120;

    /**
     * 牛肉豆堡120g口味铺市月份
     */
    private String kwYmNrdb120;

    /**
     * 去骨凤爪72g价格
     */
    private String priceQg72;

    /**
     * 去骨凤爪72g口味铺市月份
     */
    private String kwYmQg72;

    /**
     * 去骨凤爪138g价格
     */
    private String priceQg138;

    /**
     * 去骨凤爪138g口味铺市月份
     */
    private String kwYmQg138;

    /**
     * 虎皮小鸡腿80g价格
     */
    private String priceHpjt80;

    /**
     * 虎皮小鸡腿80g口味铺市月份
     */
    private String kwYmHpjt80;

    /**
     * 老卤价格
     */
    private String priceLl;

    /**
     * 老卤口味铺市月份
     */
    private String kwYmLl;

    /**
     * 虎皮单支价格
     */
    private String priceHpDz;

    /**
     * 虎皮单支口味铺市月份
     */
    private String kwYmHpDz;

    /**
     * 虎皮散称价格
     */
    private String priceHpSc;

    /**
     * 虎皮散称口味铺市月份
     */
    private String kwYmHpSc;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}