package com.sfa.operation.controller.sales.core;

import com.sfa.operation.pojo.sales.request.SalesApRequest;
import com.sfa.operation.service.sales.IApDisplayCoreService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author : liqiulin
 * @date : 2025-09-16 15
 * @describe : 常规陈列、档期陈列、零食陈列
 */
@RestController
@RequestMapping("/sales/ap_display")
public class ApDisplayCoreController {
    @Autowired
    private IApDisplayCoreService apDisplayCoreService;
    /**
     * 常规陈列 根据id更新
     */
    @PutMapping("/core/{id}")
    public void putDetail(@PathVariable("id") Long sadId, @RequestBody SalesApRequest request){
        request.setSadId(sadId);
        apDisplayCoreService.updateDetail(request);
    }

    /**
     * 档期陈列 根据id更新
     */
    @PutMapping("/core_pro/{id}")
    public void putProDisplayDetail(@PathVariable("id") Long sapdId, @RequestBody SalesApRequest request){
        request.setSapdId(sapdId);
        apDisplayCoreService.putProDisplayDetail(request);
    }

    /**
     * 零食陈列 根据id更新
     */
    @PutMapping("/core_snack/{id}")
    public void putSnackDisplayDetail(@PathVariable("id") Long sasdId, @RequestBody SalesApRequest request){
        request.setSasdId(sasdId);
        apDisplayCoreService.putSnackDisplayDetail(request);
    }

}
