package com.sfa.operation.controller.zzhao.core;

import com.sfa.common.security.utils.SecurityUtils;
import com.sfa.operation.pojo.zzhao.request.ZzProductQualityVo;
import com.sfa.operation.service.zzhao.IZzProQualityCoreService;
import com.sfa.system.api.domain.SysDept;
import com.sfa.system.api.model.LoginUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author : liqiulin
 * @date : 2025-10-30 15
 * @describe :
 */
@RestController
@RequestMapping("/zzhao/core/proQuality")
public class ZzProQualityCoreController {
    @Autowired
    private IZzProQualityCoreService zzProQualityCoreService;

    /**
     * 录入质检报告
     */
    @PostMapping("/add")
    public void add(@RequestBody ZzProductQualityVo vo) {
        LoginUser loginUser = SecurityUtils.getLoginUser();
        SysDept dept = loginUser.getSysUser().getDept();
        vo.setManufacturersName(dept.getDeptName());
        vo.setCreateBy(loginUser.getNickName());
        vo.setDeptId(dept.getDeptId());
        zzProQualityCoreService.add(vo);
    }

    /**
     * 修改质检报告
     */
    @PutMapping("/put")
    public void update(@RequestBody ZzProductQualityVo vo) {
        LoginUser loginUser = SecurityUtils.getLoginUser();
        SysDept dept = loginUser.getSysUser().getDept();
        vo.setUpdateBy(loginUser.getNickName());
        vo.setDeptId(dept.getDeptId());
        zzProQualityCoreService.update(vo);
    }
}
