package com.sfa.operation.pojo.promotion.request;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author : liqiulin
 * @date : 2025-05-29 13
 * @describe :
 */
@Data
public class ActivityPlanInfoDto {
    /**
     * 主键id
     */
    private Long id;

    /**
     * 活动计划表上传记录id
     */
    private Long planFileId;

    /**
     * promotion_manage_employee表id
     */
    private Integer employeeId;

    /**
     * 姓名
     */
    private String employeeName;

    /**
     * 员工工号
     */
    private String employeeNo;

    /**
     * 年份
     */
    private Integer year;

    /**
     * 月份
     */
    private Integer month;

    /**
     * 日期
     */
    private Date date;

    /**
     * 系统名称
     */
    private String lineName;

    /**
     * 门店名称
     */
    private String storeName;

    /**
     * 门店编码
     */
    private String storeCode;

    /**
     * 战区-勤策ID
     */
    private String orgQcId;

    /**
     * 战区名称
     */
    private String orgName;

    /**
     * 活动模式id
     */
    private Integer patternId;

    /**
     * 活动模式
     */
    private String pattern;

    /**
     * 经销商编码
     */
    private String dealerId;

    /**
     * 经销商名称
     */
    private String dealerName;

    /**
     * 是否双T门店
     */
    private String bothT;

    /**
     * 门店所属行政区域-省份名称，如：北京市、江苏省
     */
    private String province;

    /**
     * 门店所属行政区域-城市名称，如：南京市
     */
    private String city;

    /**
     * 门店所属行政区域-区县名称，如：鼓楼区
     */
    private String area;

    /**
     * 门店所在地址
     */
    private String addr;

    /**
     * 上班时间
     */
    private Date clockInTime;

    /**
     * 下班时间
     */
    private Date clockOutTime;

    /**
     * 工资
     */
    private BigDecimal salary;

    /**
     * 杂费
     */
    private BigDecimal incidentals;

    /**
     * 是否执行：1:执行；0:未执行；2:审批中；3:审批拒绝；4:未审批；
     */
    private Integer planStatus;

    /**
     * 飞书审批实例Code
     */
    private String instanceCode;

    /**
     * 飞书审批单编号
     */
    private String serialNumber;

    /**
     * 审批人
     */
    private String approvalEmpName;

    /**
     *
     */
    private Date createTime;

    /**
     *
     */
    private Date modifyTime;

    /**
     * 1:有效；0：删除；
     */
    private Integer isDelete;

    /**
     * 创建人
     */
    private String createBy;

    /**
     * 修改人
     */
    private String modifyBy;
}
