package com.sfa.operation.pojo.kq.response;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author : liqiulin
 * @date : 2024-11-04 16
 * @describe :
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class SfaKqMxDto {
    /**
     * 考勤明细ID
     */
    private Long kqmxId;

    private Date kqTime;
    private BigDecimal[] kqLocal;
    private String kqProvinc;
    private String kqCity;
    private String kqCounty;
    private String kqAddress;
    private String kqPicurl;

    /**
     * 1:上班;2:午班;3:下班;
     */
    private Integer kqType;

    /**
     * 员工ID
     */
    private Long kqUserid;

    /**
     * 考勤规则ID
     */
    private Long ruleId;

    /**
     * 考勤规则名称
     */
    private String ruleName;

    /**
     * 打卡省编码
     */
    private String kqProvinceNum;

    /**
     * 打卡城市编码
     */
    private String kqCityNum;

    /**
     * 打卡县/区编码
     */
    private String kqCountyNum;

    private Date createDate;

    /**
     * 创建者/打卡人员
     */
    private String createBy;

    /**
     * 创建人UserID
     */
    private Long createUserId;

    public SfaKqMxDto(Integer kqType) {
        this.kqType = kqType;
    }
}
