package com.sfa.operation.domain.promotion.dao.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.sfa.common.core.utils.bean.BeanUtils;
import com.sfa.operation.domain.promotion.dao.IActivityPlanInfoDao;
import com.sfa.operation.domain.promotion.entity.ActivityPlanInfo;
import com.sfa.operation.domain.promotion.mapper.ActivityPlanInfoMapper;
import com.sfa.operation.domain.promotion.wq.ActivityPlanWq;
import com.sfa.operation.pojo.promotion.request.ActivityPlanApprovalDto;
import com.sfa.operation.pojo.promotion.request.ActivityPlanInfoDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2025-05-29 11
 * @describe :
 */
@DS("promotion")
@Service
public class ActivityPlanInfoDaoImpl implements IActivityPlanInfoDao {

    @Autowired
    private ActivityPlanInfoMapper activityPlanInfoMapper;
    @Override
    public List<ActivityPlanInfoDto> findList(ActivityPlanWq qw) {
        LambdaQueryWrapper<ActivityPlanInfo> lqw = new LambdaQueryWrapper<>();
        lqw.eq(ActivityPlanInfo::getPlanStatus,qw.getPlanStatus())
                .eq(ActivityPlanInfo::getYear,qw.getYear())
                .eq(ActivityPlanInfo::getMonth,qw.getMonth());
        List<ActivityPlanInfo> activityPlanInfos = activityPlanInfoMapper.selectList(lqw);
        return BeanUtils.transitionDtos(activityPlanInfos,ActivityPlanInfoDto.class);
    }

    @Override
    public void updatePlanStatus(ActivityPlanApprovalDto approvalDto) {
        ActivityPlanInfo activityPlanInfo = new ActivityPlanInfo();
        activityPlanInfo.setFsInstanceId(approvalDto.getFsInstanceId());
        activityPlanInfo.setSerialNumber(approvalDto.getSerialNumber());
        activityPlanInfo.setPlanStatus(approvalDto.getApprovalStatus().getCode());

        LambdaQueryWrapper<ActivityPlanInfo> lqw = new LambdaQueryWrapper<>();
        lqw.in(ActivityPlanInfo::getId,approvalDto.getPlanInfoIdList());

        activityPlanInfoMapper.update(activityPlanInfo, lqw);
    }
}
