package com.sfa.operation.controller.qwenplus;

import java.util.Arrays;
import java.lang.System;

import com.alibaba.dashscope.aigc.generation.Generation;
import com.alibaba.dashscope.aigc.generation.GenerationParam;
import com.alibaba.dashscope.aigc.generation.GenerationResult;
import com.alibaba.dashscope.common.Message;
import com.alibaba.dashscope.common.Role;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.utils.JsonUtils;


/**
 * @author : liqiulin
 * @date : 2025-03-19 15
 * @describe :
 */
public class Test {

    public static GenerationResult callWithMessage() throws ApiException, NoApiKeyException, InputRequiredException {
        Generation gen = new Generation();
        Message systemMsg = Message.builder()
                .role(Role.SYSTEM.getValue())
                .content("你是一个辅助员工工作的助手。")
                .build();

        Message userMsg1 = Message.builder()
                .role(Role.USER.getValue())
                .content("你是谁？是什么角色？")
                .build();

        Message userMsg2 = Message.builder()
                .role(Role.USER.getValue())
                .content("是什么角色？")
                .build();

        GenerationParam param = GenerationParam.builder()
                .apiKey("sk-6d8476b4756648f0b740bd200234d1e6")
                .model("qwen-plus")
                .messages(Arrays.asList(systemMsg, userMsg1,userMsg2))
                .resultFormat(GenerationParam.ResultFormat.MESSAGE)
                .build();
        return gen.call(param);
    }

    public static void main(String[] args) {
        try {
            GenerationResult result = callWithMessage();
            System.out.println(JsonUtils.toJson(result));
        } catch (ApiException | NoApiKeyException | InputRequiredException e) {
            // 使用日志框架记录异常信息
            System.err.println("An error occurred while calling the generation service: " + e.getMessage());
        }
        System.exit(0);
    }
}