package com.sfa.operation.controller.sales.excel;

import com.sfa.common.core.domain.R;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.security.annotation.SalesPermissionCheck;
import com.sfa.operation.pojo.sales.request.SalesApRequest;
import com.sfa.operation.service.sales.export.IExportExcelService;
import com.sfa.operation.strategy.IExportApExcelStrategy;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;

/**
 * @Author: DouXinYu
 * @Date: 2025-12-05 17:31
 * @Description: 导出excel控制类
 */
@Slf4j
@RestController
@RequestMapping("/sales/export")
public class ApExportExcelController {

    @Autowired
    private IExportExcelService exportApExcelService;

    /**
     * 导出常规陈列的excel表格zh
     * @param salesApRequest 查询参数
     * @return 导出文件
     */
    @PostMapping("/download")
    @SalesPermissionCheck(value = SalesPermissionCheck.CheckType.USER)
    public R exportApDisplayExcel(@RequestBody SalesApRequest salesApRequest, HttpServletResponse response) {
        return exportApExcelService.exportApDisplayExcel(salesApRequest, response);
    }
}
