package com.sfa.operation.domain.risk.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * 风控门店任务表
 * @TableName risk_store_task
 */
@Accessors(chain = true)
@TableName(value ="risk_store_task")
@Data
public class RiskStoreTask implements Serializable {
    /**
     * 主键ID
     */
    @TableId(type = IdType.AUTO)
    private Long rstId;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 门店编码
     */
    private String storeCode;

    /**
     * 门店名称
     */
    private String storeName;

    /**
     * 门店类型
     */
    private String storeType;

    /**
     * 门头照图片
     */
    private String storePicture;

    /**
     * 经销商名称
     */
    private String dealerName;

    /**
     * 经销商编码
     */
    private String dealerCode;

    /**
     * 省份
     */
    private String province;

    /**
     * 城市
     */
    private String city;

    /**
     * 详细地址
     */
    private String address;

    /**
     * 坐标
     */
    private String coordinates;

    /**
     * 礼盒/礼袋是否在售(逗号分隔)
     */
    private String lhlds;

    /**
     * SKU数量
     */
    private Integer skuNum;

    /**
     * 长效图片(逗号分隔)
     */
    private String longTimePictures;

    /**
     * 备注
     */
    private String remark;
    /**
     * 常规陈列判定结果
     */
    private String cgclRiskR;
    /**
     * 档期陈列判定结果
     */
    private String dqclRiskR;

    /**
     * 创建人
     */
    private String createBy;

    /**
     * 创建人工号
     */
    private String createEmpNo;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新者
     */
    private String updateBy;

    /**
     * 更新时间
     */
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}