package com.sfa.operation.service.risk.impl;

import com.sfa.common.core.utils.bean.BeanUtils;
import com.sfa.operation.domain.risk.dao.IRiskStoreTaskDao;
import com.sfa.operation.pojo.risk.request.RiskStoreTaskVo;
import com.sfa.operation.pojo.risk.response.RiskStoreTaskDto;
import com.sfa.operation.service.risk.IRiskStoreTaskCoreService;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author : liqiulin
 * @date : 2025-08-28 11
 * @describe :
 */
@Service
public class RiskStoreTaskCoreServiceImpl implements IRiskStoreTaskCoreService {
    @Autowired
    private IRiskStoreTaskDao riskStoreTaskDao;

    /**
     * 创建售点任务
     */
    @Override
    public RiskStoreTaskDto inspectStore(RiskStoreTaskVo riskStoreTaskVo) {
        RiskStoreTaskDto taskDto = BeanUtils.transitionDto(riskStoreTaskVo, RiskStoreTaskDto.class);
        taskDto.setCreateBy(riskStoreTaskVo.getOperName());
        taskDto.setCreateEmpNo(riskStoreTaskVo.getOperEmpNo());
        return riskStoreTaskDao.insert(taskDto);
    }
    /**
     * 修改售点任务
     */
    @Override
    public RiskStoreTaskDto updateInspectStore(RiskStoreTaskDto taskDto) {
        return riskStoreTaskDao.updateInspectStore(taskDto);
    }

    @Override
    public RiskStoreTaskDto.RiskStoreTaskDetailDto saveStoreDetail(RiskStoreTaskVo.TaskDetailVo taskDetail) {
        return riskStoreTaskDao.saveStoreDetail(taskDetail.getRstId(),taskDetail.getDetailName());
    }

    @Override
    public RiskStoreTaskDto.RiskStoreTaskDetailDto updateStoreDetail(RiskStoreTaskDto.RiskStoreTaskDetailDto riskStoreTaskDetailDto) {
        return riskStoreTaskDao.updateStoreDetail(riskStoreTaskDetailDto);
    }

    @Override
    public void deleteStoreDetail(Long rstdId) {
        riskStoreTaskDao.deleteStoreDetail(rstdId);
    }
}
