package com.sfa.operation.controller.sfa.core;

import com.sfa.common.security.utils.SecurityUtils;
import com.sfa.operation.pojo.sfa.request.KqMxVo;
import com.sfa.operation.pojo.sfa.response.SfaKqMxDto;
import com.sfa.operation.service.sfa.IKqMxCoreService;
import com.sfa.system.api.model.LoginUser;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;

/**
 * @author : liqiulin
 * @date : 2024-11-04 17
 * @describe :
 */
@RestController
@RequestMapping("/kqmx/core")
public class KqMxCoreController {

    @Autowired
    IKqMxCoreService kqMxCoreService;

    /**
     * 打卡
     * @param kqMxVo 打卡基础明细
     */
    @PostMapping
    public void kqClockIn(@RequestBody @Validated KqMxVo kqMxVo){
        SfaKqMxDto kqMxDto = new SfaKqMxDto();
        BeanUtils.copyProperties(kqMxVo,kqMxDto);
        LoginUser loginUser = SecurityUtils.getLoginUser();
        Date date = new Date();
        kqMxDto.setKqUserid(loginUser.getUserid())
                .setKqTime(date)
                .setRuleId(loginUser.getRuleId())
                .setRuleName(loginUser.getRuleName())
                .setCreateDate(date)
                .setCreateBy(loginUser.getUsername())
                .setCreateUserId(loginUser.getUserid())
                .setKqAddress(kqMxDto.getKqProvinc() + "-" + kqMxDto.getKqCity() + "-" + kqMxDto.getKqCounty() + "-" + kqMxDto.getKqAddress());
        kqMxCoreService.kqClockIn(kqMxDto);
    }
}
