package com.sfa.operation.domain.feishu.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 勤策-经销商人客关系表，来源：https://wangxiaolu.feishu.cn/sheets/QIYlsvCL9hwmBJtJ7v5ctYVsnDF?sheet=3eadb4
 * @TableName qince_market_employee
 */
@TableName(value ="qince_market_employee")
@Data
public class QinceMarketEmployee implements Serializable {
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Integer id;

    /**
     * 经销商代码
     */
    private String dealerCode;

    /**
     * 经销商名称
     */
    private String dealerName;

    /**
     * 大区部门编码
     */
    private String dqDeptCode;

    /**
     * 战区部门编码
     */
    private String zqDeptCode;

    /**
     * 大区总工号
     */
    private String dqEmpNo;

    /**
     * 战区经理工号
     */
    private String zqEmpNo;

    /**
     * 城市经理工号
     */
    private String csEmpNo;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date modifyTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}