package com.sfa.operation.domain.sfa.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.WXLSQLException;
import com.sfa.operation.domain.sfa.dao.ISfaKqmxDao;
import com.sfa.operation.domain.sfa.entity.SfaKqmxEntity;
import com.sfa.operation.domain.sfa.mapper.SfaKqmxMapper;
import com.sfa.operation.pojo.sfa.response.SfaKqMxDto;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-11-05 10
 * @describe :
 */
@Service
public class SfaKqmxDaoImpl implements ISfaKqmxDao {

    @Autowired
    SfaKqmxMapper sfaKqmxMapper;

    @Override
    public void add(SfaKqMxDto kqMxDto) {
        try {
            SfaKqmxEntity kqDo = new SfaKqmxEntity();
            BeanUtils.copyProperties(kqMxDto,kqDo);
            kqDo.setKqLon(kqMxDto.getKqLocal()[0]);
            kqDo.setKqLat(kqMxDto.getKqLocal()[1]);
            sfaKqmxMapper.insertOne(kqDo);
        }catch (Exception e) {
            String eMsg = e.getCause().getMessage();
            if (eMsg.contains("for key 'date_type_unique'")) {
                throw new WXLSQLException(ECode.KQMX_CURRENTLY_TYPE_KQ_HAS);
            }else {
                throw new WXLSQLException(ECode.KQMX_CLOCK_IN_ERRPR);
            }
        }
    }

    @Override
    public List<SfaKqMxDto> betweentDate(Date dateStart, Long userId) {
        LambdaQueryWrapper<SfaKqmxEntity> qw = new LambdaQueryWrapper<>();
        qw.ge(SfaKqmxEntity::getCreateDate, dateStart);
        qw.eq(SfaKqmxEntity::getCreateUserId,userId);
        qw.select(SfaKqmxEntity::getCreateDate, SfaKqmxEntity::getKqmxId, SfaKqmxEntity::getKqTime, SfaKqmxEntity::getKqAddress, SfaKqmxEntity::getKqPicurl, SfaKqmxEntity::getKqType);

        List<SfaKqmxEntity> dos = sfaKqmxMapper.selectList(qw);
        List<SfaKqMxDto> dtos = com.sfa.common.core.utils.bean.BeanUtils.transitionDtos(dos, SfaKqMxDto.class);
        return dtos;
    }
}
