package com.sfa.operation.domain.sales.dao.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.sfa.common.core.utils.StringUtils;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.core.web.page.TableSupport;
import com.sfa.operation.domain.sales.dao.ISalesApPromotionDao;
import com.sfa.operation.domain.sales.entity.SalesApPromotion;
import com.sfa.operation.domain.sales.mapper.SalesApPromotionMapper;
import com.sfa.operation.domain.sales.wq.SalesApWq;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2025-09-17 15
 * @describe :
 */
@DS("bi")
@Service
public class SalesApPromotionImplDao implements ISalesApPromotionDao {
    @Autowired
    private SalesApPromotionMapper salesApPromotionMapper;

    @Override
    public PageInfo page(SalesApWq salesApWq) {
        LambdaQueryWrapper<SalesApPromotion> qw = buildWq(salesApWq);
        Page<SalesApPromotion> salesApDisplayPage = salesApPromotionMapper.selectPage(TableSupport.pageI(), qw);
        PageInfo pageInfo = new PageInfo(salesApDisplayPage);
        return pageInfo;
    }
    private LambdaQueryWrapper<SalesApPromotion> buildWq(SalesApWq salesApWq) {
        LambdaQueryWrapper<SalesApPromotion> qw = new LambdaQueryWrapper<>();
        if (StringUtils.isNotBlank(salesApWq.getDealerCode())) {
            qw.eq(SalesApPromotion::getDealerCode, salesApWq.getDealerCode());
        }
        if (StringUtils.isNotBlank(salesApWq.getCityManager())) {
            qw.eq(SalesApPromotion::getCityManager, salesApWq.getCityManager());
        }
        if (Objects.nonNull(salesApWq.getSalesMonth())){
            qw.eq(SalesApPromotion::getSalesMonth, salesApWq.getSalesMonth());
        }
        return qw;
    }
}
