package com.sfa.operation.domain.sales.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * 营销中心-活动计划-档期（计划+执行）
 * @TableName sales_ap_promotion
 */
@TableName(value ="sales_ap_promotion")
@Data
public class SalesApPromotion implements Serializable {
    /**
     * 主键ID
     */
    @TableId(type = IdType.AUTO)
    private Long sapId;

    /**
     * 陈列所属月份
     */
    private Date salesMonth;

    /**
     * 销售大区
     */
    private String regionName;

    /**
     * 销售战区
     */
    private String districtName;

    /**
     * 经销商-省份
     */
    private String dealerProvince;

    /**
     * 经销商-城市
     */
    private String dealerCity;

    /**
     * 经销商-代码
     */
    private String dealerCode;

    /**
     * 经销商名称
     */
    private String dealerName;

    /**
     * 经销商类型
     */
    private String dealerType;

    /**
     * 开户日期
     */
    private Date openingDate;

    /**
     * 闭户日期
     */
    private Date closingDate;

    /**
     * 大区总监
     */
    private String regionManager;

    /**
     * 战区经理
     */
    private String districtManager;

    /**
     * 城市经理
     */
    private String cityManager;

    /**
     * 系统名称
     */
    private String lineName;

    /**
     * 系统类型
     */
    private String lineType;

    /**
     * 渠道大类
     */
    private String channelDl;

    /**
     * 渠道小类
     */
    private String channelXl;

    /**
     * 系统业态
     */
    private String lineLf;

    /**
     * 门店数
     */
    private String storeCount;

    /**
     * 档期执行月份
     */
    private String promotionExecutionMonth;

    /**
     * 档期目标网点数
     */
    private Integer promotionSn;

    /**
     * 档期计划-促销规格
     */
    private String plannedPromotionSpec;

    /**
     * 档期计划-促销口味
     */
    private String plannedPromotionFlavor;
    private String plannedPromotionFlavorOther;

    /**
     * 档期执行-促销规格
     */
    private String actualPromotionSpec;

    /**
     * 实际执行规格(填报)
     */
    private String actualPromotionSpecRe;

    /**
     * 档期执行-促销口味
     */
    private String actualPromotionFlavor;

    /**
     * 实际执行口味(填报)
     */
    private String actualPromotionFlavorRe;

    /**
     * 档期规格是否执行,有计划默认否
     */
    private String specExecutionStatus;

    /**
     * 促销口味是否执行,有计划默认未执行
     */
    private String flavorExecutionStatus;

    /**
     * 合计费用
     */
    private BigDecimal totalCost;

    /**
     * 合计费率（%）
     */
    private Double totalCostRate;

    /**
     * 计划-档期形式
     */
    private String plannedPromotionFormat;

    /**
     * 计划-核销方式
     */
    private String plannedVerificationMethod;

    /**
     * 计划-档期规则
     */
    private String plannedPromotionRules;

    /**
     * 计划-档期前补差天数
     */
    private Integer plannedPrePromotionAdjustDays;

    /**
     * 计划-档期后补差天数
     */
    private Integer plannedPostPromotionAdjustDays;

    /**
     * 计划-档期开始时间
     */
    private Date plannedPromotionStartDate;

    /**
     * 实际-档期开始时间
     */
    private Date actualPromotionStartDate;

    /**
     * 计划-档期结束时间
     */
    private Date plannedPromotionEndDate;

    /**
     * 实际-档期结束时间
     */
    private Date actualPromotionEndDate;

    /**
     * 档期是否开展,有计划默认否
     */
    private String promotionImplementationStatus;

    /**
     * 时间是否执行,有计划默认否
     */
    private String timeExecutionStatus;

    /**
     * 计划-补差开始时间
     */
    private Date plannedAdjustmentStartDate;

    /**
     * 计划-补差结束时间
     */
    private Date plannedAdjustmentEndDate;

    /**
     * 计划促销机制
     */
    private String plannedPromotionMechanism;

    /**
     * 实际促销机制
     */
    private String actualPromotionMechanism;

    /**
     * 促销机制是否执行,有计划默认否
     */
    private String promotionMechanismExecutionStatus;

    /**
     * 预估袋数
     */
    private Integer estimatedBagCount;

    /**
     * 档期备货量（袋）
     */
    private Integer promotionStockQuantity;

    /**
     * 单包厂价（单包）
     */
    private BigDecimal unitFactoryPrice;

    /**
     * 正常供价（单包）
     */
    private BigDecimal normalSupplyPrice;

    /**
     * 日常零售价（单包）
     */
    private BigDecimal regularRetailPrice;

    /**
     * 计划促销售价（单包）
     */
    private BigDecimal plannedPromotionPrice;

    /**
     * 实际促销售价（单包）
     */
    private BigDecimal actualPromotionPrice;

    /**
     * 促销价是否执行,有计划默认否
     */
    private String promotionPriceExecutionStatus;

    /**
     * 实际执行价格(填报)
     */
    private String actualPromotionPriceRe;

    /**
     * 正常经销商毛利现状
     */
    private String normalDealerMarginStatus;

    /**
     * 系统前台毛利保证
     */
    private String systemFrontendMarginGuarantee;

    /**
     * 系统后台毛利保证
     */
    private String systemBackendMarginGuarantee;

    /**
     * 系统促销毛利保证
     */
    private String systemPromotionMarginGuarantee;

    /**
     * 经销商毛利保证
     */
    private String dealerMarginGuarantee;

    /**
     * 单袋补差金额（费用）
     */
    private BigDecimal unitBagAdjustmentAmount;

    /**
     * 补差费比（%）
     */
    private Double adjustmentCostRatio;

    /**
     * 整体补差（费用）
     */
    private BigDecimal totalAdjustmentCost;

    /**
     * 档期是否执行,有计划默认否
     */
    private String promotionExecutionStatus;

    /**
     * 计划-海报形式
     */
    private String plannedPosterFormat;

    /**
     * 计划-海报费用
     */
    private String plannedPosterCost;

    /**
     * 实际-海报形式
     */
    private String actualPosterFormat;

    /**
     * 海报是否执行,有计划默认否
     */
    private String posterExecutionStatus;

    /**
     * 门店数
     */
    private Integer storeCountInt;

    /**
     * 店均费用
     */
    private BigDecimal averageStoreCost;

    /**
     * 费用
     */
    private BigDecimal cost;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新者
     */
    private String updateBy;

    /**
     * 更新时间
     */
    private Date updateTime;
    @TableField(exist = false)
    private Boolean isActualPromotionStartDate;
    @TableField(exist = false)
    private Boolean isActualPromotionEndDate;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}