package com.sfa.operation.service.zzhao.impl;

import com.alibaba.fastjson2.JSONObject;
import com.sfa.operation.domain.zzhao.dao.IZzProductQualityDao;
import com.sfa.operation.pojo.zzhao.request.ZzProductQualityVo;
import com.sfa.operation.pojo.zzhao.response.ZzProductQualityDto;
import com.sfa.operation.service.zzhao.IZzProQualityCoreService;
import com.sfa.operation.util.T100Util;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author : liqiulin
 * @date : 2025-10-30 16
 * @describe :
 */
@Service
public class ZzProQualityCoreServiceImpl implements IZzProQualityCoreService {
    @Autowired
    private IZzProductQualityDao zzProductQualityDao;
    @Autowired
    private T100Util t100Util;

    @Override
    public void add(ZzProductQualityVo vo) {
        ZzProductQualityDto dto = new ZzProductQualityDto();
        BeanUtils.copyProperties(vo, dto);
        zzProductQualityDao.insert(dto);

        JSONObject dataMap = new JSONObject();
        // 料号、批号、检验连接、厂家
        dataMap.put("imjyuc001",vo.getPrdCode());
        dataMap.put("imjyuc002",vo.getManufactureBatchNo());
        dataMap.put("imjyuc003",vo.getQualityUrl());
        dataMap.put("imjyuc004",vo.getManufacturersName());

        JSONObject deptJson = new JSONObject();
        deptJson.putObject("payload").putObject("std_data").putObject("parameter").putArray("data").add(dataMap);

        // 数据同步T100
        t100Util.createProQuality(deptJson);

    }

    @Override
    public void update(ZzProductQualityVo vo) {
        ZzProductQualityDto dto = new ZzProductQualityDto();
        BeanUtils.copyProperties(vo, dto);
        ZzProductQualityDto oldDto = zzProductQualityDao.update(dto);

        JSONObject oldMap = new JSONObject();
        // 料号、批号、检验连接、厂家
        oldMap.put("imjyuc001",oldDto.getPrdCode());
        oldMap.put("imjyuc002",oldDto.getManufactureBatchNo());
        oldMap.put("imjyuc003",oldDto.getQualityUrl());

        JSONObject newMap = new JSONObject();
        // 料号、批号、检验连接、厂家
        newMap.put("imjyuc001",vo.getPrdCode());
        newMap.put("imjyuc002",vo.getManufactureBatchNo());
        newMap.put("imjyuc003",vo.getQualityUrl());

        JSONObject parameterMap = new JSONObject();
        parameterMap.put("old",oldMap);
        parameterMap.put("new",newMap);

        JSONObject deptJson = new JSONObject();
        deptJson.putObject("payload").putObject("std_data").put("parameter",parameterMap);

        // 数据同步T100
        t100Util.updateProQuality(deptJson);
    }
}
