package com.sfa.operation.domain.zzhao.dao.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.CheckedException;
import com.sfa.common.core.exception.WXLSQLException;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.core.web.page.TableSupport;
import com.sfa.operation.domain.zzhao.dao.IZzProductQualityDao;
import com.sfa.operation.domain.zzhao.entity.ZzProductQuality;
import com.sfa.operation.domain.zzhao.mapper.ZzProductQualityMapper;
import com.sfa.operation.domain.zzhao.wq.ZzProductQualityWq;
import com.sfa.operation.pojo.zzhao.response.ZzProductQualityDto;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2025-10-30 15
 * @describe :
 */
@Service
@DS("bi")
public class ZzProductQualityDaoImpl implements IZzProductQualityDao {
    @Autowired
    private ZzProductQualityMapper zzProductQualityMapper;

    @Override
    public void insert(ZzProductQualityDto dto) {
        try {
            ZzProductQuality entity = new ZzProductQuality();
            BeanUtils.copyProperties(dto, entity);
            zzProductQualityMapper.insert(entity);
        }catch (Exception e){
            String eMsg = e.getCause().getMessage();
            if (eMsg.contains("for key 'psm_unique'")) {
                throw new WXLSQLException(ECode.ZZ_PRODUCT_QUALITY_EXIST_ERROR);
            }
            throw new WXLSQLException(ECode.DB_TABLE_UPDATE_ERROR);
        }
    }

    @Override
    public PageInfo page(ZzProductQualityWq wq) {
        LambdaQueryWrapper<ZzProductQuality> qw = buildQw(wq);
        Page<ZzProductQuality> page = zzProductQualityMapper.selectPage(TableSupport.pageI(), qw);
        PageInfo<ZzProductQuality> pageInfo = new PageInfo<>(page);
        return pageInfo;
    }

    @Override
    public ZzProductQualityDto update(ZzProductQualityDto dto) {
        ZzProductQuality zzProductQualityOld = zzProductQualityMapper.selectById(dto.getZpqId());
        if (zzProductQualityOld == null) {
            throw new CheckedException(ECode.DATA_NULL_ERROR);
        }
       // 判断创建时间是否已超过48小时
       if ((zzProductQualityOld.getCreateTime().getTime() + (48 * 60 * 60 * 1000)) < System.currentTimeMillis()) {
           throw new CheckedException(ECode.ZZ_PRODUCT_QUALITY_UPDATE_ERROR);
       }
        if (!dto.getDeptId().equals(zzProductQualityOld.getDeptId())){
            throw new CheckedException(ECode.ZZ_PRODUCT_QUALITY_DEPT_ERROR);
        }
        ZzProductQuality entity = new ZzProductQuality();
        BeanUtils.copyProperties(dto, entity);
        zzProductQualityMapper.updateById(entity);
        return com.sfa.common.core.utils.bean.BeanUtils.transitionDto(zzProductQualityOld, ZzProductQualityDto.class);
    }

    private LambdaQueryWrapper<ZzProductQuality> buildQw(ZzProductQualityWq wq){
        LambdaQueryWrapper<ZzProductQuality> qw = new LambdaQueryWrapper<>();
        if (Objects.nonNull(wq.getDeptId())){
            qw.eq(ZzProductQuality::getDeptId, wq.getDeptId());
        }
        if (StringUtils.isNotBlank(wq.getPrdCN())) {
            qw.and(
                    wrapper -> wrapper.like(ZzProductQuality::getPrdName, wq.getPrdCN())
                            .or()
                            .like(ZzProductQuality::getPrdCode, wq.getPrdCN())
            );
        }
        if (wq.getShipDate() != null){
            qw.eq(ZzProductQuality::getShipDate, wq.getShipDate());
        }
        if (StringUtils.isNotBlank(wq.getManufacturersNameLike())){
            qw.like(ZzProductQuality::getManufacturersName, wq.getManufacturersNameLike());
        }
        if (StringUtils.isNotBlank(wq.getManufactureBatchNoLike())){
            qw.like(ZzProductQuality::getManufactureBatchNo, wq.getManufactureBatchNoLike());
        }
        qw.orderByDesc(ZzProductQuality::getCreateTime,ZzProductQuality::getShipDate);
        return qw;
    }
}
